/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.core.tasks.external;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.error.TaskError;
import ch.e2e.builder.compiler.build.tasks.handler.Selector;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.TaskFactory;
import ch.e2e.builder.compiler.utils.TokenManager;
import com.scheer.pas.compiler.core.tasks.external.ExternalTaskError;
import com.scheer.pas.compiler.core.tasks.external.ExternalTaskFatalError;
import com.scheer.pas.compiler.core.tasks.external.ExternalTaskResult;
import com.scheer.pas.compiler.core.tasks.external.ExternalTaskWarning;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ExternalTask
extends CacheAbleTask {
    private final Client client;
    private final String taskUrl;
    private final TokenManager tokenManager;
    private final String[] sources;

    public ExternalTask(SourceManager sourceManager, String id, Client client, String serviceUrl, TokenManager tokenManager, String[] sources) {
        super(sourceManager, id);
        String encodedId;
        this.client = client;
        this.tokenManager = tokenManager;
        this.sources = sources;
        try {
            encodedId = URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            encodedId = id;
        }
        this.taskUrl = serviceUrl + "/compiler/project/" + sourceManager.getProjectFolder().getName() + "/task/" + encodedId;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> set = super.getSourceSet();
        set.addAll(Arrays.asList(this.sources));
        return set;
    }

    @Override
    public boolean isUpToDate() {
        return false;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        WebTarget webTarget = this.client.target(this.taskUrl);
        this.getQueryParams().forEach((arg_0, arg_1) -> ((WebTarget)webTarget).queryParam(arg_0, arg_1));
        try (Response response = webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)this.tokenManager.getBearerTokenString()).build("POST").invoke();){
            this.handleResponse(response);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    private Map<String, Object[]> getQueryParams() {
        return Collections.emptyMap();
    }

    protected void handleResponse(Response response) {
        Response.StatusType statusInfo = response.getStatusInfo();
        final int statusCode = statusInfo.getStatusCode();
        if (this.isSuccessful(response) || statusCode == Response.Status.CONFLICT.getStatusCode()) {
            ExternalTaskResult result = (ExternalTaskResult)response.readEntity(ExternalTaskResult.class);
            if (result.getErrors() != null) {
                result.getErrors().forEach(error -> {
                    switch (error.getType()) {
                        case "FatalError": {
                            this.getErrorHandler().fatalError((BuilderFatalError)new ExternalTaskFatalError(error.getCode(), error.getParameters(), error.getMessage(), error.getTaskId(), error.getOriginalElement()));
                            break;
                        }
                        case "Warning": {
                            this.getErrorHandler().warning((BuilderWarning)new ExternalTaskWarning(error.getCode(), error.getParameters(), error.getMessage(), error.getTaskId(), error.getOriginalElement()));
                            break;
                        }
                        default: {
                            this.getErrorHandler().error((AbstractBuilderError)new ExternalTaskError(error.getCode(), error.getParameters(), error.getMessage(), error.getTaskId(), error.getOriginalElement()));
                        }
                    }
                });
            }
        } else {
            String statusMessage = statusInfo.getReasonPhrase();
            this.getErrorHandler().error((AbstractBuilderError)new TaskError("EXT0001", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("code", String.valueOf(statusCode));
                    this.put("taskId", ExternalTask.this.getId());
                }
            }));
            Logging.logger.warning(String.format("%s - Error sending request to '%s' - (%d - %s)", this.getId(), this.taskUrl, statusCode, statusMessage));
        }
    }

    protected void handleError(Exception e) {
        Logging.logger.warning(String.format("%s - Error sending request to '%s' - (%s)", this.getId(), this.taskUrl, e.getMessage()));
        this.getErrorHandler().error((Throwable)e);
    }

    protected boolean isSuccessful(Response response) {
        return response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL);
    }

    public static class Factory
    extends TaskFactory {
        private final Selector selector;
        private final Client client;
        private final String serviceUrl;
        private final TokenManager tokenManager;
        private final String[] sources;

        public Factory(Selector selector, Client client, String serviceUrl, TokenManager tokenManager, Double priority) {
            this(selector, client, serviceUrl, tokenManager, new String[0], priority);
        }

        public Factory(Selector selector, Client client, String serviceUrl, TokenManager tokenManager, String[] sources, Double priority) {
            super(priority);
            this.selector = selector;
            this.client = client;
            this.serviceUrl = serviceUrl;
            this.tokenManager = tokenManager;
            this.sources = sources;
        }

        @Override
        public Boolean matchId(String id) {
            return this.selector.select(id);
        }

        @Override
        public CacheAbleTask createTask(String id, SourceManager sourceManager) {
            return new ExternalTask(sourceManager, id, this.client, this.serviceUrl, this.tokenManager, this.sources);
        }
    }
}

