/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.utils;

import java.time.Instant;
import java.util.Objects;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.UriBuilder;
import net.jcip.annotations.GuardedBy;
import org.keycloak.representations.AccessTokenResponse;

public class TokenManager
implements AutoCloseable {
    private final String realm;
    private final GrantType grantType;
    private final String scope;
    private final String clientId;
    private final String clientSecret;
    private final String username;
    private final String password;
    private final Client restClient;
    private final WebTarget baseTarget;
    private final Object accessTokenLock = new Object();
    @GuardedBy(value="accessTokenLock")
    private AccessTokenResponse accessToken;
    @GuardedBy(value="accessTokenLock")
    private Instant accessTokenExpiration;
    @GuardedBy(value="accessTokenLock")
    private Instant refreshTokenExpiration;

    private TokenManager(Builder builder) {
        this.realm = builder.realm;
        this.grantType = builder.grantType;
        this.scope = builder.scope;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.username = builder.username;
        this.password = builder.password;
        this.restClient = builder.restClient == null ? ClientBuilder.newClient() : builder.restClient;
        this.baseTarget = this.restClient.target(UriBuilder.fromPath((String)builder.serverUrl));
    }

    public static Builder newBuilder(String serverUrl, String realm) {
        return new Builder(serverUrl, realm);
    }

    public String getAccessTokenString() {
        return this.getAccessToken().getToken();
    }

    public String getBearerTokenString() {
        return String.format("Bearer %s", this.getAccessTokenString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessTokenResponse getAccessToken() {
        Object object = this.accessTokenLock;
        synchronized (object) {
            if (this.accessToken == null) {
                return this.grantToken();
            }
            if (this.tokenExpired()) {
                return this.refreshToken();
            }
            return this.accessToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessTokenResponse grantToken() {
        Form form = this.grantTokenForm();
        Instant now = Instant.now();
        Object object = this.accessTokenLock;
        synchronized (object) {
            this.accessToken = this.post("/realms/{realm-name}/protocol/openid-connect/token", form, AccessTokenResponse.class);
            this.accessTokenExpiration = now.plusSeconds(this.accessToken.getExpiresIn());
            this.refreshTokenExpiration = now.plusSeconds(this.accessToken.getRefreshExpiresIn());
            return this.accessToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessTokenResponse refreshToken() {
        Object object = this.accessTokenLock;
        synchronized (object) {
            if (this.accessToken == null || this.accessToken.getRefreshToken() == null || this.refreshTokenExpired()) {
                return this.grantToken();
            }
            try {
                Form form = this.refreshTokenForm();
                Instant now = Instant.now();
                this.accessToken = this.post("/realms/{realm-name}/protocol/openid-connect/token", form, AccessTokenResponse.class);
                this.accessTokenExpiration = now.plusSeconds(this.accessToken.getExpiresIn());
                return this.accessToken;
            }
            catch (Exception e) {
                return this.grantToken();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        Object object = this.accessTokenLock;
        synchronized (object) {
            if (this.accessToken == null || this.accessToken.getRefreshToken() == null) {
                return;
            }
            Form form = this.newForm().param("refresh_token", this.accessToken.getRefreshToken());
            this.post("/realms/{realm-name}/protocol/openid-connect/logout", form, Void.class);
            this.accessToken = null;
        }
    }

    private Form grantTokenForm() {
        Form form = this.newForm().param("grant_type", this.grantType.toString()).param("scope", this.scope);
        if (this.grantType == GrantType.PASSWORD) {
            form.param("username", this.username).param("password", this.password);
        }
        return form;
    }

    @GuardedBy(value="accessTokenLock")
    private Form refreshTokenForm() {
        return this.newForm().param("grant_type", "refresh_token").param("refresh_token", this.accessToken.getRefreshToken());
    }

    private Form newForm() {
        return new Form().param("client_id", this.clientId).param("client_secret", this.clientSecret);
    }

    private <T> T post(String path, Form form, Class<T> responseType) {
        return (T)this.baseTarget.path(path).resolveTemplate("realm-name", (Object)this.realm).request(new String[]{"application/x-www-form-urlencoded"}).post(Entity.form((Form)form), responseType);
    }

    @GuardedBy(value="accessTokenLock")
    private boolean tokenExpired() {
        return Instant.now().isAfter(this.accessTokenExpiration);
    }

    @GuardedBy(value="accessTokenLock")
    private boolean refreshTokenExpired() {
        return Instant.now().isAfter(this.refreshTokenExpiration);
    }

    @Override
    public void close() {
        this.restClient.close();
    }

    public void invalidateToken(AccessTokenResponse accessToken) {
        this.invalidateToken(accessToken.getToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateToken(String token) {
        Object object = this.accessTokenLock;
        synchronized (object) {
            if (this.accessToken != null && this.accessToken.getToken().equals(token)) {
                this.accessTokenExpiration = Instant.MIN;
            }
        }
    }

    public static class Builder {
        private final String serverUrl;
        private final String realm;
        private GrantType grantType = GrantType.PASSWORD;
        private String scope;
        private String clientId;
        private String clientSecret;
        private String username;
        private String password;
        private Client restClient;

        private Builder(String serverUrl, String realm) {
            this.serverUrl = Objects.requireNonNull(serverUrl, "serverUrl required");
            this.realm = Objects.requireNonNull(realm, "realm required");
        }

        public Builder grantType(GrantType grantType) {
            this.grantType = grantType;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder restClient(Client restClient) {
            this.restClient = restClient;
            return this;
        }

        public TokenManager build() {
            this.validate();
            return new TokenManager(this);
        }

        private void validate() {
            switch (this.grantType) {
                case PASSWORD: {
                    Objects.requireNonNull(this.clientId, "clientId required");
                    Objects.requireNonNull(this.username, "username required");
                    Objects.requireNonNull(this.password, "password required");
                    break;
                }
                case CLIENT_CREDENTIALS: {
                    Objects.requireNonNull(this.clientId, "clientId required");
                    Objects.requireNonNull(this.clientSecret, "clientSecret required with grant_type=client_credentials");
                }
            }
        }
    }

    public static enum GrantType {
        PASSWORD("password"),
        CLIENT_CREDENTIALS("client_credentials");

        private final String internalName;

        private GrantType(String internalName) {
            this.internalName = internalName;
        }

        public String toString() {
            return this.internalName;
        }
    }
}

