/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.DeploymentTemplate;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;

public class UmlElementListCellRenderer
extends DefaultListCellRenderer {
    private static UmlElementListCellRenderer renderer = new UmlElementListCellRenderer();

    private UmlElementListCellRenderer() {
    }

    public static UmlElementListCellRenderer getInstance() {
        return renderer;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Icon icon = null;
        if (value instanceof UmlElement) {
            icon = ((UmlElement)value).getStereotype().getCustomization().getIcon();
        } else if (value instanceof BridgeStereotype) {
            icon = ((BridgeStereotype)value).getCustomization().getIcon();
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        if (value instanceof DeploymentTemplate) {
            String text = ((UmlElement)value).getDescription() == null || ((UmlElement)value).getDescription().getText().length() == 0 ? ((UmlElement)value).getName() : ((UmlElement)value).getName() + '(' + ((UmlElement)value).getDescription().getText() + ')';
            this.setText(text);
        }
        return this;
    }
}

