/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net;

import ch.e2e.builder.compiler.net.LoginFailedException;
import ch.e2e.io.Base64Tools;
import ch.e2e.io.FileUtilities;
import ch.e2e.util.StringTools;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.InvalidKeyException;

public class MultipartFormRequest {
    private static final String AUTHORIZATION = "Authorization";
    private static final String BASIC = "Basic";
    private URL url;
    private HttpURLConnection urlConnection;
    private String boundary;
    private int boundaryCounter;

    public MultipartFormRequest(String url) throws MalformedURLException, IOException {
        this.url = new URL(url);
        this.boundaryCounter = 0;
    }

    public void openConnection(String protocol) throws ProtocolException, IOException {
        this.urlConnection = (HttpURLConnection)this.url.openConnection();
        this.urlConnection.setDoOutput(true);
        this.urlConnection.setDoInput(true);
        this.urlConnection.setUseCaches(false);
        this.urlConnection.setRequestMethod(protocol);
        this.urlConnection.setReadTimeout(30000);
        this.createBoundary();
        this.urlConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    public void setBasicAuthentication(String userName, String password) throws InvalidKeyException {
        if (userName == null || password == null) {
            throw new InvalidKeyException("Username and password must not be null.");
        }
        String value = Base64Tools.encodeToString((String)("Basic " + userName + ":" + password));
        this.addHeaderField(AUTHORIZATION, value);
    }

    public void addHeaderField(String name, String value) {
        this.urlConnection.setRequestProperty(name, value);
    }

    public void closeConnection() {
        this.urlConnection.disconnect();
    }

    public void sendParameter(String name, String value) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byteOut.write(("--" + this.boundary + "\r\n").getBytes());
        byteOut.write(("Content-Disposition: form-data;name=\"" + name + "\"").getBytes());
        byteOut.write("\r\n\r\n".getBytes());
        byteOut.write(value.getBytes());
        byteOut.write("\r\n".getBytes());
        byteOut.writeTo(this.urlConnection.getOutputStream());
        byteOut.flush();
        byteOut.close();
        this.urlConnection.getOutputStream().flush();
    }

    public void sendFile(String paramName, File file) throws FileNotFoundException, IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byteOut.write(("--" + this.boundary + "\r\n").getBytes());
        byteOut.write(("Content-Disposition: form-data;name=\"" + paramName + "\"; filename=\"" + file.getAbsolutePath() + "\"\r\n\nContent-Type: application/octet-stream\n\n").getBytes());
        byteOut.write("\r\n".getBytes());
        FileInputStream uploadFileReader = new FileInputStream(file);
        FileUtilities.copy((InputStream)uploadFileReader, (OutputStream)byteOut);
        byteOut.write("\r\n".getBytes());
        byteOut.writeTo(this.urlConnection.getOutputStream());
        byteOut.flush();
        byteOut.close();
        this.urlConnection.getOutputStream().flush();
    }

    public void sendStream(String paramName, String filename, InputStream in) throws FileNotFoundException, IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byteOut.write(("--" + this.boundary + "\r\n").getBytes());
        byteOut.write(("Content-Disposition: form-data;name=\"" + paramName + "\"; filename=\"" + filename + "\"\r\n").getBytes());
        byteOut.write("\r\n".getBytes());
        FileUtilities.copy((InputStream)in, (OutputStream)byteOut);
        byteOut.write("\r\n".getBytes());
        byteOut.writeTo(this.urlConnection.getOutputStream());
        byteOut.flush();
        byteOut.close();
        this.urlConnection.getOutputStream().flush();
    }

    public void flush() throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byteOut.write(("--" + this.boundary + "--\n\r").getBytes());
        byteOut.writeTo(this.urlConnection.getOutputStream());
        byteOut.flush();
        byteOut.close();
        this.urlConnection.getOutputStream().flush();
        this.urlConnection.getOutputStream().close();
    }

    public InputStream getResultStream() throws IOException, LoginFailedException {
        int code = this.urlConnection.getResponseCode();
        if (code == 401) {
            throw new LoginFailedException();
        }
        InputStream result = this.urlConnection.getResponseCode() < 400 ? this.urlConnection.getInputStream() : this.urlConnection.getErrorStream();
        return result;
    }

    public String getAnswer() throws IOException, LoginFailedException {
        InputStream resultStream = this.getResultStream();
        InputStreamReader in = new InputStreamReader(resultStream);
        StringWriter out = new StringWriter();
        FileUtilities.copy((Reader)in, (Writer)out);
        return out.toString();
    }

    private void createBoundary() {
        this.boundary = "builderboundary-" + StringTools.prependZeros((String)String.valueOf(this.boundaryCounter), (int)3);
    }
}

