/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.wsdl;

import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import ch.e2e.builder.compiler.document.importer.idl.IDLTransformImportTransaction;
import ch.e2e.builder.compiler.document.importer.wsdl.WSDLDataModel;
import ch.e2e.builder.compiler.document.importer.wsdl.WSDLImportSource;
import ch.e2e.builder.compiler.uml.DataModel;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WsdlImportTransaction
extends IDLTransformImportTransaction {
    public static final String WSDL_DOCUMENT_SOURCE = "wsdl.document.source";
    public static final String WSDL_IMPORT_MODELS = "wsdl.import.model";
    public static final String WSDL_MODULES_FROM_NAMESPACES_PARAM_KEY = "modulesFromNamespace";
    public static final String WSDL_IGNORE_ORDER_PARAM_KEY = "ignoreOrder";
    private Boolean createElementClass = false;
    private File importsFolder;
    private final String description;

    public WsdlImportTransaction(File importsFolder, String description, Helpers helpers) {
        super(helpers);
        this.importsFolder = importsFolder;
        this.description = description;
    }

    public Boolean isCreateElementClass() {
        return this.createElementClass;
    }

    public void setCreateElementClass(Boolean createElementClass) {
        this.createElementClass = createElementClass;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    protected String getScript() {
        return "wsdl2idl";
    }

    @Override
    protected String getSourceType(Document wsdl2idl) {
        return wsdl2idl.getDocumentElement().getAttribute("sourceType");
    }

    @Override
    protected String getSourceKey() {
        return WSDL_DOCUMENT_SOURCE;
    }

    @Override
    protected String getImportSourcesKey() {
        return WSDL_IMPORT_MODELS;
    }

    @Override
    protected void setExtensionsParameters(DataModel dataModel) {
        if (dataModel instanceof WSDLDataModel) {
            ((WSDLDataModel)dataModel).setCreateElementClass(this.isCreateElementClass());
        }
    }

    @Override
    protected IDLImportSource createImportSource(String name, Element idlElement) {
        return new WSDLImportSource(name, idlElement, this.importsFolder, this.getHelpers());
    }

    @Override
    protected Map<String, Object> getDefaultExtensionParameters() {
        Map<String, Object> result = super.getDefaultExtensionParameters();
        result.put("createElementClass", false);
        return result;
    }

    @Override
    protected Map<String, Object> readExtensionsParameters(Element element) {
        Map<String, Object> result = super.readExtensionsParameters(element);
        if (element == null) {
            this.setCreateElementClass(true);
        } else {
            try {
                String createElementClass = (String)DomUtilities.evaluate((Node)element, (String)"wsdl/@createElementClass", (QName)XPathConstants.STRING);
                if (createElementClass != null && !createElementClass.equals("")) {
                    this.setCreateElementClass(createElementClass.equals("true"));
                } else {
                    this.setCreateElementClass(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        result.put("createElementClass", this.isCreateElementClass());
        return result;
    }
}

