/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document;

import ch.e2e.builder.base.tools.Utilities;
import ch.e2e.builder.compiler.descriptor.RepositoryDescriptor;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentComparator;
import ch.e2e.builder.compiler.document.UmlDocumentCompilerSettings;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;

public class DocumentFolder {
    protected File documentFolder;
    private static final UmlDocumentComparator umlComparator = new UmlDocumentComparator();
    private ArrayList<UmlDocument> documents;
    private ArrayList<DocumentFolder> subfolders;
    private int documentCount;
    private String name;
    private FileFilter documentFileFilter = new DocumentFileFilter();
    private UmlDocumentFactory umlDocumentFactory;

    public UmlDocumentFactory getUmlDocumentFactory() {
        return this.umlDocumentFactory;
    }

    protected DocumentFolder(UmlDocumentCompilerSettings settings) {
        this.umlDocumentFactory = new UmlDocumentFactory(settings);
    }

    private DocumentFolder(File documentFolder, UmlDocumentFactory umlDocumentFactory) {
        this.umlDocumentFactory = umlDocumentFactory;
        this.init(documentFolder);
        this.setName(documentFolder.getName());
    }

    public final File getDocumentFolder() {
        return this.documentFolder;
    }

    protected final boolean hasChanged() {
        File[] documents;
        File[] folders = FileUtilities.getAllDirectories((File)this.documentFolder, (String[])Utilities.EXCLUDED_FOLDERS);
        boolean changed = this.hasChanged(folders.length, (documents = FileUtilities.getFileList((File)this.documentFolder, (FileFilter)this.documentFileFilter)).length);
        if (changed) {
            this.checkFiles(documents);
            this.checkFolders(folders);
        } else {
            changed = this.checkUmlDocuments();
            for (DocumentFolder folder : this.subfolders) {
                changed |= folder.hasChanged();
            }
        }
        this.countDocuments();
        return changed;
    }

    public final int size() {
        return this.documents.size() + this.subfolders.size();
    }

    public final Object get(int index) {
        if (index < this.subfolders.size()) {
            return this.subfolders.get(index);
        }
        return this.documents.get(index - this.subfolders.size());
    }

    public final ArrayList<UmlDocument> getAllDocuments() {
        ArrayList<UmlDocument> allDocuments = new ArrayList<UmlDocument>(this.documents);
        for (DocumentFolder subfolder : this.subfolders) {
            allDocuments.addAll(subfolder.getAllDocuments());
        }
        return allDocuments;
    }

    public final String toString() {
        return this.name;
    }

    protected final ArrayList<RepositoryDescriptor> getAllDescriptors() {
        ArrayList<RepositoryDescriptor> descriptors = new ArrayList<RepositoryDescriptor>();
        for (UmlDocument document : this.documents) {
            RepositoryDescriptor descriptor = document.getDescriptor();
            if (descriptor == null || descriptor.isEmpty()) continue;
            descriptors.add(descriptor);
        }
        for (DocumentFolder subfolder : this.subfolders) {
            descriptors.addAll(subfolder.getAllDescriptors());
        }
        Object[] descriptorArray = new RepositoryDescriptor[descriptors.size()];
        descriptors.toArray(descriptorArray);
        Arrays.sort(descriptorArray);
        descriptors.clear();
        descriptors.addAll(Arrays.asList(descriptorArray));
        return descriptors;
    }

    protected final void countDocuments() {
        this.documentCount = this.documents.size();
        for (DocumentFolder subfolder : this.subfolders) {
            subfolder.countDocuments();
            this.documentCount += subfolder.getDocumentCount();
        }
    }

    protected final void setName(String name) {
        this.name = name;
    }

    protected final void clear() {
        for (UmlDocument document : this.documents) {
            this.umlDocumentFactory.remove(document);
        }
        this.documents.clear();
        for (DocumentFolder folder : this.subfolders) {
            folder.clear();
        }
        this.subfolders.clear();
        this.documentCount = 0;
    }

    protected final void init(File documentFolder) {
        this.documentFolder = documentFolder;
        this.readUmlDocuments();
        this.createSubfolders();
    }

    private boolean hasChanged(int foldersLength, int documentsLength) {
        return foldersLength != this.subfolders.size() || documentsLength != this.documents.size();
    }

    private void checkFolders(File[] folders) {
        ArrayList<File> foldersToAdd = new ArrayList<File>(Arrays.asList(folders));
        ArrayList<DocumentFolder> missingFolders = new ArrayList<DocumentFolder>(this.subfolders);
        for (File folder : folders) {
            this.checkFolder(folder, foldersToAdd, missingFolders);
        }
        this.removeMissingFolders(missingFolders);
        this.addFolders(foldersToAdd);
    }

    private void checkFolder(File folder, ArrayList<File> foldersToAdd, ArrayList<DocumentFolder> missingFolders) {
        for (DocumentFolder subfolder : this.subfolders) {
            if (!subfolder.documentFolder.equals(folder)) continue;
            foldersToAdd.remove(folder);
            missingFolders.remove(subfolder);
            subfolder.hasChanged();
            break;
        }
    }

    private void removeMissingFolders(ArrayList<DocumentFolder> missingFolders) {
        for (DocumentFolder subfolder : missingFolders) {
            subfolder.clear();
            this.subfolders.remove(subfolder);
        }
    }

    private void addFolders(ArrayList<File> foldersToAdd) {
        for (File aFoldersToAdd : foldersToAdd) {
            this.subfolders.add(new DocumentFolder(aFoldersToAdd, this.umlDocumentFactory));
        }
    }

    private void checkFiles(File[] files) {
        this.removeMissingFiles();
        ArrayList<File> documentFiles = new ArrayList<File>(Arrays.asList(files));
        for (File documentFile : files) {
            this.checkFile(documentFile, documentFiles);
        }
        this.addNewFiles(documentFiles);
        int length = documentFiles.size();
        if (length > 0) {
            this.sortDocuments(new ArrayList<UmlDocument>(this.documents));
        }
    }

    private void addNewFiles(ArrayList<File> documentFiles) {
        for (File file : documentFiles) {
            UmlDocument umlDocument = this.umlDocumentFactory.getUmlDocument(file);
            if (umlDocument == null) continue;
            this.documents.add(umlDocument);
        }
    }

    private void removeMissingFiles() {
        ArrayList<UmlDocument> filesToRemove = new ArrayList<UmlDocument>();
        for (UmlDocument umlDocument : this.documents) {
            if (umlDocument.exists()) continue;
            filesToRemove.add(umlDocument);
        }
        for (UmlDocument umlDocument : filesToRemove) {
            this.removeDocument(umlDocument);
        }
    }

    private void checkFile(File documentFile, ArrayList<File> documentFiles) {
        for (UmlDocument umlDocument : this.documents) {
            if (!umlDocument.getOriginalFile().equals(documentFile)) continue;
            documentFiles.remove(documentFile);
            break;
        }
    }

    private int getDocumentCount() {
        return this.documentCount;
    }

    private void readUmlDocuments() {
        this.documents = new ArrayList();
        if (this.documentFolder.exists()) {
            ArrayList<UmlDocument> documentList = new ArrayList<UmlDocument>();
            this.readUmlDocuments(documentList);
            this.sortDocuments(documentList);
        }
    }

    private void sortDocuments(ArrayList<UmlDocument> documentList) {
        UmlDocument[] documentArray = new UmlDocument[documentList.size()];
        documentList.toArray(documentArray);
        Arrays.sort(documentArray, umlComparator);
        this.documents.clear();
        this.documents.addAll(Arrays.asList(documentArray));
    }

    private boolean checkUmlDocuments() {
        boolean changed = false;
        ArrayList<UmlDocument> documentsToRemove = new ArrayList<UmlDocument>();
        for (UmlDocument document : this.documents) {
            if (document.exists()) {
                changed |= document.hasChanged();
                continue;
            }
            documentsToRemove.add(document);
        }
        if (documentsToRemove.size() > 0) {
            changed = true;
            for (UmlDocument document : documentsToRemove) {
                this.removeDocument(document);
            }
        }
        return changed;
    }

    private void removeDocument(UmlDocument document) {
        this.umlDocumentFactory.remove(document);
        this.documents.remove(document);
    }

    private void readUmlDocuments(ArrayList<UmlDocument> documentList) {
        File[] umlFiles;
        for (File umlFile : umlFiles = FileUtilities.getFileList((File)this.documentFolder, (FileFilter)this.documentFileFilter)) {
            UmlDocument document = this.umlDocumentFactory.getUmlDocument(umlFile);
            if (document == null) continue;
            documentList.add(document);
        }
    }

    private void createSubfolders() {
        File[] folders;
        this.subfolders = new ArrayList();
        for (File folder : folders = FileUtilities.getAllDirectories((File)this.documentFolder, (String[])Utilities.EXCLUDED_FOLDERS)) {
            DocumentFolder subfolder = new DocumentFolder(folder, this.umlDocumentFactory);
            this.subfolders.add(subfolder);
        }
    }

    private class DocumentFileFilter
    implements FileFilter {
        private DocumentFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            String filename = pathname.getName().toLowerCase();
            return pathname.isFile() && !filename.endsWith(".e2e.temp.xml") && (filename.endsWith(".xml") || filename.endsWith(".xmi") || filename.endsWith(".zip") || filename.endsWith(".mdzip"));
        }
    }
}

