/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AsynchronousTraceInformation {
    private ArrayList<File> asynchronousTraceTemplates;

    public AsynchronousTraceInformation(UmlDocument umlDocument) {
        ArrayList<UmlDocument> allUmlDocuments = umlDocument.getAllUmlDocuments();
        this.findAsynchronousTraceTemplates(allUmlDocuments);
    }

    public Document createAsynchronousTraceInformation() throws IOException, ParserConfigurationException, SAXException {
        Document result = DomUtilities.newDocument((String)"AsynchronousTrace");
        for (File template : this.asynchronousTraceTemplates) {
            Document traceInfo = DomUtilities.parse((File)template, (boolean)false, (boolean)false, (boolean)false);
            NodeList stateClasses = traceInfo.getDocumentElement().getChildNodes();
            int length = stateClasses.getLength();
            for (int i = 0; i < length; ++i) {
                if (!(stateClasses.item(i) instanceof Element)) continue;
                result.getDocumentElement().appendChild(result.importNode(stateClasses.item(i), true));
            }
        }
        return result;
    }

    private void findAsynchronousTraceTemplates(ArrayList<UmlDocument> allUmlDocuments) {
        this.asynchronousTraceTemplates = new ArrayList();
        for (UmlDocument document : allUmlDocuments) {
            File workingFolder = document.getDocumentWorkingFolder();
            File template = new File(workingFolder, "asynchronous.trace.template");
            if (!template.exists()) continue;
            this.asynchronousTraceTemplates.add(template);
        }
    }
}

