/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.source.IDLSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import ch.e2e.builder.compiler.uml.DataModel;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class IDL2XmiTransformationModelTask
extends CacheAbleTask
implements XSLTTransformSource {
    private Document model;

    public static Boolean select(String id) {
        return id.endsWith(Extensions._idl_xmiTransformationModel_xml);
    }

    public IDL2XmiTransformationModelTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getIDLSourceId());
        return result;
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getIDLSourceId());
        result.addAll(this.getImportedIdlSourcesIds());
        return result;
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._idl_xmiTransformationModel_xml;
    }

    protected String getIDLSourceId() {
        return Files.idl__IDL_idl_xml(this.getDestinationFileNameWithoutExtension());
    }

    protected IDLImportSource getIDLImportSource() {
        return ((IDLSource)this.getSourceManager().getSource(this.getIDLSourceId())).getIDLImportSource();
    }

    protected List<String> getImportedIdlSourcesIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (String imported : this.getIDLImportSource().getImportedModels()) {
            ids.add(Files.idl__IDL_idl_xml(imported));
        }
        return ids;
    }

    private List<IDLSource> getImportedIdlSources() {
        ArrayList<IDLSource> list = new ArrayList<IDLSource>();
        for (String id : this.getImportedIdlSourcesIds()) {
            list.add((IDLSource)this.getSource(id));
        }
        return list;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            DataModel dataModel = this.getIDLImportSource().getDataModel();
            IDLImportSource.ElementMaps elementMaps = this.getIDLImportSource().getElementMaps();
            HashMap<String, UmlElement> allClasses = new HashMap<String, UmlElement>(elementMaps.allClasses);
            for (IDLSource idlSource : this.getImportedIdlSources()) {
                allClasses.putAll(idlSource.getIDLImportSource().getElementMaps().allClasses);
            }
            this.getIDLImportSource().replaceUsingImportedClasses(allClasses);
            this.getIDLImportSource().getHelpers().getXmiIDFactory().setGlobalPrefix(dataModel.getName() + '_');
            this.model = dataModel.createDocument();
            DomUtilities.serialize((File)this.getDestinationFile(), (Document)this.model, (boolean)true);
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

