/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.library2class;

import ch.e2e.builder.compiler.build.tasks.SplitXmlDocumentUsingXpathTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.io.File;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class LibraryClasses2ClassXmlTask
extends SplitXmlDocumentUsingXpathTask {
    public static Boolean select(String id) {
        return id.endsWith(Extensions._class_xml) && id.startsWith(Folders.libs);
    }

    public LibraryClasses2ClassXmlTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._class_xml;
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getSourcePath());
        return result;
    }

    @Override
    protected String getSourcePath() {
        File tmp;
        File libraryFolder = this.getDestinationFile();
        while (Objects.nonNull(libraryFolder) && !(tmp = libraryFolder.getParentFile()).getName().equals(Folders.libs)) {
            libraryFolder = tmp;
        }
        return Folders.libs_ + libraryFolder.getName() + Extensions._library_classes_xml;
    }

    @Override
    protected String getSplitXpathExpression() {
        return String.format("//xuml:result/xuml:class[@file-path='%s']", this.getId());
    }
}

