/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.libraries;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.AnnotationNotFoundException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.error.TaskError;
import ch.e2e.builder.compiler.build.tasks.source.JarSourceFile;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.document.importer.ImportModel;
import ch.e2e.builder.compiler.document.importer.ImporterData;
import ch.e2e.builder.compiler.document.importer.java.ImporterJarfile;
import ch.e2e.builder.compiler.document.importer.java.JavaImportSource;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class Jar2XmiTransformationModelTask
extends CacheAbleTask
implements XSLTTransformSource {
    public static Boolean select(String id) {
        return id.endsWith(Extensions._jar_xmiTransformationModel_xml);
    }

    public Jar2XmiTransformationModelTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._jar_xmiTransformationModel_xml;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            JavaImportSource source = (JavaImportSource)this.getImporterData().getSource("java.import.source");
            source.addSharedPackages();
            Document javaDocument = source.getSourceDocument();
            ImportModel importModel = new ImportModel(this.getImporterData().getFilename(), this.getDestinationFile());
            importModel.setModel(javaDocument);
            importModel.setDataModel(source.getDataModel());
            Document model = importModel.getModel();
            DomUtilities.serialize((File)this.getDestinationFile(), (Document)model, (boolean)true);
            this.copyFiles();
        }
        catch (AnnotationNotFoundException e) {
            this.getErrorHandler().error((AbstractBuilderError)new TaskError("ELIB0008", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("name", e.getFilename());
                }
            }));
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    private void copyFiles() throws IOException, AnnotationNotFoundException {
        List allJarfiles = (List)this.getImporterData().getSource("all.jarfiles");
        File jarfileFolder = (File)this.getImporterData().getSource("jarfile.folder");
        for (ImporterJarfile file : allJarfiles) {
            File importedJarfile = new File(jarfileFolder, file.getName());
            try {
                FileUtilities.copyFile((File)file.getOriginalFile(), (File)importedJarfile);
            }
            catch (IOException e) {
                this.getErrorHandler().error((Throwable)e);
            }
        }
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getJarImportSourceId());
        return result;
    }

    protected String getJarImportSourceId() {
        return Folders.jars_ + this.getDestinationFileNameWithoutExtension() + Extensions._jar;
    }

    protected ImporterData getImporterData() throws IOException, AnnotationNotFoundException {
        return ((JarSourceFile)this.getSourceManager().getSource(this.getJarImportSourceId())).getImporterData();
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

