/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.axiom;

import java.util.Stack;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.option.axiom.AxiomDocumentNodeWrapper;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;

public class AxiomWriter
extends Builder {
    private OMFactory factory;
    private OMDocument document;
    private Stack<OMContainer> ancestors = new Stack();
    private boolean implicitDocumentNode = false;
    private FastStringBuffer textBuffer = new FastStringBuffer(256);

    public AxiomWriter(PipelineConfiguration pipe) {
        super(pipe);
        this.factory = OMAbstractFactory.getOMFactory();
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.document = this.factory.createOMDocument();
        this.ancestors.push((OMContainer)this.document);
        this.textBuffer.setLength(0);
    }

    @Override
    public void endDocument() throws XPathException {
        this.ancestors.pop();
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        OMElement element;
        this.flush();
        String local = nameCode.getLocalPart();
        String uri = nameCode.getURI();
        String prefix = nameCode.getPrefix();
        if (this.ancestors.isEmpty()) {
            this.startDocument(0);
            this.implicitDocumentNode = true;
        }
        if (uri.length() != 0) {
            OMNamespace ns = this.factory.createOMNamespace(uri, prefix);
            element = this.factory.createOMElement(local, ns);
        } else {
            element = this.factory.createOMElement(local, null);
        }
        if (this.ancestors.size() == 1) {
            this.document.setOMDocumentElement(element);
        } else {
            this.ancestors.peek().addChild((OMNode)element);
        }
        this.ancestors.push((OMContainer)element);
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        for (NamespaceBinding ns : namespaceBindings) {
            String prefix = ns.getPrefix();
            String uri = ns.getURI();
            if (prefix.equals("")) {
                ((OMElement)this.ancestors.peek()).declareDefaultNamespace(uri);
                continue;
            }
            if (uri.equals("")) continue;
            OMNamespace ons = this.factory.createOMNamespace(uri, prefix);
            ((OMElement)this.ancestors.peek()).declareNamespace(ons);
        }
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        String local = nameCode.getLocalPart();
        String uri = nameCode.getURI();
        String prefix = nameCode.getPrefix();
        OMNamespace ns = uri.isEmpty() ? null : this.factory.createOMNamespace(uri, prefix);
        OMAttribute att = this.factory.createOMAttribute(local, ns, value.toString());
        if ((properties & 0x800) != 0 || local.equals("id") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            att.setAttributeType("ID");
        } else if ((properties & 0x1000) != 0) {
            att.setAttributeType("IDREF");
        }
        ((OMElement)this.ancestors.peek()).addAttribute(att);
    }

    @Override
    public void startContent() throws XPathException {
        this.flush();
    }

    @Override
    public void endElement() throws XPathException {
        this.flush();
        this.ancestors.pop();
        OMContainer parent = this.ancestors.peek();
        if (parent == this.document && this.implicitDocumentNode) {
            this.endDocument();
        }
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.textBuffer.append(chars);
    }

    private void flush() {
        if (this.textBuffer.length() != 0) {
            OMText text = this.factory.createOMText(this.textBuffer.toString());
            this.ancestors.peek().addChild((OMNode)text);
            this.textBuffer.setLength(0);
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        this.flush();
        OMContainer parent = this.ancestors.peek();
        OMProcessingInstruction pi = this.factory.createOMProcessingInstruction(parent, target, data.toString());
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.flush();
        OMContainer parent = this.ancestors.peek();
        OMComment comment = this.factory.createOMComment(parent, chars.toString());
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    public OMDocument getDocument() {
        return this.document;
    }

    @Override
    public NodeInfo getCurrentRoot() {
        return new AxiomDocumentNodeWrapper(this.document, this.systemId, this.config);
    }
}

