/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.sf.saxon.trans.XPathException;

public class Mailer2 {
    Session session;
    Address sender;
    String server;
    String user;
    String password;
    MimeMessage message;
    Multipart multipart;

    public Mailer2(String server, int port, String user, String password) {
        this.server = server;
        this.user = user;
        this.password = password;
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", server);
        props.setProperty("mail.smtp.port", port + "");
        props.setProperty("mail.smtp.user", user);
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.debug", "false");
        this.session = Session.getDefaultInstance((Properties)props, (Authenticator)new MyAuthenticator());
        this.session.setDebug(false);
        this.message = new MimeMessage(this.session);
        this.multipart = new MimeMultipart();
    }

    public Mailer2(Properties props, String password) {
        this.server = props.getProperty("mail.smtp.host");
        this.user = props.getProperty("mail.smtp.user");
        this.password = password;
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.debug", "false");
        this.session = Session.getDefaultInstance((Properties)props, (Authenticator)new MyAuthenticator());
        this.session.setDebug(false);
        this.message = new MimeMessage(this.session);
        this.multipart = new MimeMultipart();
    }

    public void setSender(String emailAddress, String realName) throws MessagingException, UnsupportedEncodingException {
        this.sender = realName == null ? new InternetAddress(emailAddress) : new InternetAddress(emailAddress, realName);
        this.message.setFrom(this.sender);
        Address[] replyTo = new Address[]{this.sender};
        this.message.setReplyTo(replyTo);
    }

    public void addRecipients(Message.RecipientType recipientType, Address[] addresses) throws XPathException {
        try {
            this.message.addRecipients(recipientType, addresses);
        }
        catch (MessagingException e) {
            throw new XPathException("Invalid recipient in send-mail:" + e.getMessage(), "SXJM0002");
        }
    }

    public void addBodyPart(BodyPart part) throws XPathException {
        try {
            this.multipart.addBodyPart(part);
        }
        catch (MessagingException e) {
            throw new XPathException("Invalid content of email:" + e.getMessage(), "SXJM0002");
        }
    }

    public void sendMail(String subject, String content) throws MessagingException {
        this.message.setSubject(subject);
        this.message.setSentDate(new Date());
        MimeBodyPart body = new MimeBodyPart();
        if (content.contains("<html") || content.contains("<xhtml")) {
            body.setText(content, "UTF-8", "html");
        } else {
            body.setText(content);
        }
        this.multipart.addBodyPart((BodyPart)body);
        this.message.setContent(this.multipart);
        Transport transport = this.session.getTransport("smtp");
        transport.connect(this.server, this.user, this.password);
        transport.sendMessage((Message)this.message, this.message.getAllRecipients());
        transport.close();
    }

    private class MyAuthenticator
    extends Authenticator {
        private MyAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(Mailer2.this.user, Mailer2.this.password);
        }
    }
}

