/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import com.saxonica.functions.hof.FunctionLiteral;
import com.saxonica.functions.hof.PartialApply;
import com.saxonica.functions.hof.UnresolvedXQueryFunctionItem;
import com.saxonica.functions.hof.UserFunctionReference;
import com.saxonica.functions.registry.XPath31HOFunctionSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ParserExtension;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.ma.map.TupleItemType;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.VisibilityProvenance;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyFunctionTypeWithAssertions;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;

public class HofParserExtension
extends ParserExtension {
    protected Stack<InlineFunctionDetails> inlineFunctionStack = new Stack();

    @Override
    public Expression parseNamedFunctionReference(XPathParser p) throws XPathException {
        BuiltInFunctionSet.Entry details;
        StructuredQName functionName;
        int arity;
        StaticContext env;
        int offset;
        block9: {
            Tokenizer t = p.getTokenizer();
            String fname = t.currentTokenValue;
            offset = t.currentTokenStartOffset;
            env = p.getStaticContext();
            p.nextToken();
            p.expect(209);
            NumericValue number = NumericValue.parseNumber(t.currentTokenValue);
            if (!(number instanceof IntegerValue)) {
                p.grumble("Number following '#' must be an integer");
            }
            if (number.compareTo(0L) < 0 || number.compareTo(Integer.MAX_VALUE) > 0) {
                p.grumble("Number following '#' is out of range", "FOAR0002");
            }
            arity = (int)number.longValue();
            p.nextToken();
            functionName = null;
            p.getQNameParser().setDefaultNamespace(env.getDefaultFunctionNamespace());
            try {
                functionName = p.getQNameParser().parse(fname);
                if (functionName.getPrefix().equals("") && XPathParser.isReservedFunctionName31(functionName.getLocalPart())) {
                    p.grumble("The unprefixed function name '" + functionName.getLocalPart() + "' is reserved in XPath 3.1");
                }
            }
            catch (XPathException e) {
                p.grumble(e.getMessage(), e.getErrorCodeLocalPart());
                if ($assertionsDisabled || functionName != null) break block9;
                throw new AssertionError();
            }
        }
        Function fcf = null;
        try {
            FunctionLibrary lib = env.getFunctionLibrary();
            SymbolicName.F sn = new SymbolicName.F(functionName, arity);
            fcf = lib.getFunctionItem(sn, env);
            if (fcf == null) {
                p.grumble("Function " + functionName.getEQName() + "#" + arity + " not found", "XPST0017", offset);
            }
        }
        catch (XPathException e) {
            p.grumble(e.getMessage(), "XPST0017", offset);
        }
        if (functionName.hasURI("http://www.w3.org/2005/xpath-functions") && fcf instanceof SystemFunction && (details = ((SystemFunction)fcf).getDetails()) != null && (details.properties & 0x583C) != 0) {
            SystemFunction lookup = XPath31HOFunctionSet.getInstance().makeFunction("function-lookup", 2);
            lookup.setRetainedStaticContext(env.makeRetainedStaticContext());
            return lookup.makeFunctionCall(Literal.makeLiteral(new QNameValue(functionName, BuiltInAtomicType.QNAME)), Literal.makeLiteral(Int64Value.makeIntegerValue(arity)));
        }
        Expression ref = HofParserExtension.makeNamedFunctionReference(functionName, fcf);
        p.setLocation(ref, offset);
        return ref;
    }

    private static Expression makeNamedFunctionReference(StructuredQName functionName, Function fcf) {
        if (fcf instanceof UserFunction && !functionName.hasURI("http://www.w3.org/1999/XSL/Transform")) {
            return new UserFunctionReference((UserFunction)fcf);
        }
        if (fcf instanceof UnresolvedXQueryFunctionItem) {
            return ((UnresolvedXQueryFunctionItem)fcf).getFunctionReference();
        }
        return new FunctionLiteral(fcf);
    }

    @Override
    public ItemType parseFunctionItemType(XPathParser p, AnnotationList annotations) throws XPathException {
        Tokenizer t = p.getTokenizer();
        p.nextToken();
        ArrayList<SequenceType> argTypes = new ArrayList<SequenceType>(3);
        if (t.currentToken == 207 || t.currentToken == 17) {
            p.nextToken();
            p.expect(204);
            p.nextToken();
            if (annotations.isEmpty()) {
                return AnyFunctionType.getInstance();
            }
            return new AnyFunctionTypeWithAssertions(annotations);
        }
        while (t.currentToken != 204) {
            SequenceType arg = p.parseSequenceType();
            argTypes.add(arg);
            if (t.currentToken == 204) break;
            if (t.currentToken == 7) {
                p.nextToken();
                continue;
            }
            p.grumble("Expected ',' or ')' after function argument type, found '" + Token.tokens[t.currentToken] + '\'');
        }
        p.nextToken();
        if (t.currentToken == 71) {
            p.nextToken();
            SequenceType resultType = p.parseSequenceType();
            SequenceType[] argArray = new SequenceType[argTypes.size()];
            argArray = argTypes.toArray(argArray);
            return new SpecificFunctionType(argArray, resultType, annotations);
        }
        if (!argTypes.isEmpty()) {
            p.grumble("Result type must be given if an argument type is given: expected 'as (type)'");
            return null;
        }
        p.grumble("function() is no longer allowed for a general function type: must be function(*)");
        return null;
    }

    @Override
    public ItemType parseExtendedItemType(XPathParser p) throws XPathException {
        Tokenizer t = p.getTokenizer();
        if (t.currentToken == 48) {
            p.checkSyntaxExtensions("type alias");
            p.nextToken();
            p.expect(201);
            StructuredQName typeAlias = p.getQNameParser().parse(t.currentTokenValue);
            ItemType realType = p.getStaticContext().resolveTypeAlias(typeAlias);
            if (realType == null) {
                p.grumble("The type alias ~" + typeAlias.getDisplayName() + " has not been defined");
            }
            p.nextToken();
            return realType;
        }
        if (t.currentToken == 69 && t.currentTokenValue.equals("tuple")) {
            return this.parseTupleType(p);
        }
        if (t.currentToken == 69 && t.currentTokenValue.equals("union")) {
            return this.parseUnionType(p);
        }
        return null;
    }

    @Override
    public Expression parseTildePattern(XPathParser p) throws XPathException {
        Tokenizer t = p.getTokenizer();
        ItemType type = this.parseExtendedItemType(p);
        Expression expr = new InstanceOfExpression(new ContextItemExpression(), SequenceType.makeSequenceType(type, 16384));
        expr = new FilterExpression(new ContextItemExpression(), expr);
        return expr;
    }

    private ItemType parseTupleType(XPathParser p) throws XPathException {
        Tokenizer t = p.getTokenizer();
        p.nextToken();
        ArrayList<String> fieldNames = new ArrayList<String>(6);
        ArrayList<SequenceType> fieldTypes = new ArrayList<SequenceType>(6);
        HashSet<String> optionalFields = new HashSet<String>(6);
        boolean extensible = false;
        while (true) {
            p.expect(201);
            String name = t.currentTokenValue;
            if (!NameChecker.isValidNCName(name)) {
                p.grumble(Err.wrap(name) + " is not a valid NCName");
            }
            fieldNames.add(name);
            p.nextToken();
            if (t.currentToken == 213) {
                p.nextToken();
                optionalFields.add(name);
            }
            SequenceType arg = SequenceType.ANY_SEQUENCE;
            if (t.currentToken == 75) {
                p.nextToken();
                arg = p.parseSequenceType();
            }
            fieldTypes.add(arg);
            if (t.currentToken == 204) break;
            if (t.currentToken == 7) {
                p.nextToken();
                if (t.currentToken != 207 && t.currentToken != 17) continue;
                extensible = true;
                p.nextToken();
                p.expect(204);
                break;
            }
            p.grumble("Expected ',' or ')' after field in tuple type, found '" + Token.tokens[t.currentToken] + '\'');
        }
        p.nextToken();
        if (fieldNames.isEmpty()) {
            p.grumble("Tuple type must contain at least one field");
            return null;
        }
        return new TupleItemType(fieldNames, fieldTypes, optionalFields, extensible);
    }

    public ItemType parseUnionType(XPathParser p) throws XPathException {
        p.getStaticContext().getConfiguration().checkLicensedFeature(1, "union types", -1);
        Tokenizer t = p.getTokenizer();
        p.nextToken();
        ArrayList<AtomicType> memberTypes = new ArrayList<AtomicType>(6);
        while (true) {
            p.expect(201);
            StructuredQName member = p.getQNameParser().parse(t.currentTokenValue);
            ItemType type = p.getPlainType(member);
            if (type instanceof AtomicType) {
                memberTypes.add((AtomicType)type);
            } else {
                p.grumble("Type " + t.currentTokenValue + " exists, but is not atomic");
            }
            p.nextToken();
            if (t.currentToken == 204) break;
            if (t.currentToken == 7) {
                p.nextToken();
                continue;
            }
            p.grumble("Expected ',' or ')' after member name in union type, found '" + Token.tokens[t.currentToken] + '\'');
        }
        p.nextToken();
        ItemType type = p.getStaticContext().getConfiguration().makeUserUnionType(memberTypes);
        return type == null ? BuiltInAtomicType.ANY_ATOMIC : type;
    }

    @Override
    public Expression makeArgumentPlaceMarker(XPathParser p) {
        return null;
    }

    @Override
    protected Expression parseInlineFunction(XPathParser p, AnnotationList annotations) throws XPathException {
        Expression body;
        Tokenizer t = p.getTokenizer();
        int offset = t.currentTokenStartOffset;
        InlineFunctionDetails details = new InlineFunctionDetails();
        details.outerVariables = new Stack();
        for (LocalBinding lb : p.getRangeVariables()) {
            details.outerVariables.push(lb);
        }
        details.outerVariablesUsed = new ArrayList<LocalBinding>(4);
        details.implicitParams = new ArrayList<UserFunctionParameter>(4);
        this.inlineFunctionStack.push(details);
        p.setRangeVariables(new Stack<LocalBinding>());
        p.nextToken();
        HashSet<StructuredQName> paramNames = new HashSet<StructuredQName>(8);
        ArrayList<UserFunctionParameter> params = new ArrayList<UserFunctionParameter>(8);
        SequenceType resultType = SequenceType.ANY_SEQUENCE;
        int paramSlot = 0;
        while (t.currentToken != 204) {
            p.expect(21);
            p.nextToken();
            p.expect(201);
            String argName = t.currentTokenValue;
            StructuredQName argQName = p.makeStructuredQName(argName, "");
            if (paramNames.contains(argQName)) {
                p.grumble("Duplicate parameter name " + Err.wrap(t.currentTokenValue, 5), "XQST0039");
            }
            paramNames.add(argQName);
            SequenceType paramType = SequenceType.ANY_SEQUENCE;
            p.nextToken();
            if (t.currentToken == 71) {
                p.nextToken();
                paramType = p.parseSequenceType();
            }
            UserFunctionParameter arg = new UserFunctionParameter();
            arg.setRequiredType(paramType);
            arg.setVariableQName(argQName);
            arg.setSlotNumber(paramSlot++);
            params.add(arg);
            p.declareRangeVariable(arg);
            if (t.currentToken == 204) break;
            if (t.currentToken == 7) {
                p.nextToken();
                continue;
            }
            p.grumble("Expected ',' or ')' after function argument, found '" + Token.tokens[t.currentToken] + '\'');
        }
        t.setState(1);
        p.nextToken();
        if (t.currentToken == 71) {
            t.setState(2);
            p.nextToken();
            resultType = p.parseSequenceType();
        }
        p.expect(59);
        t.setState(0);
        p.nextToken();
        if (t.currentToken == 215 && p.isAllowXPath31Syntax()) {
            t.lookAhead();
            p.nextToken();
            body = Literal.makeEmptySequence();
        } else {
            body = p.parseExpression();
            p.expect(215);
            t.lookAhead();
            p.nextToken();
        }
        ExpressionTool.setDeepRetainedStaticContext(body, p.getStaticContext().makeRetainedStaticContext());
        int arity = paramNames.size();
        for (int i = 0; i < arity; ++i) {
            p.undeclareRangeVariable();
        }
        Expression result = HofParserExtension.makeInlineFunctionValue(p, annotations, details, params, resultType, body);
        p.setLocation(result, offset);
        p.setRangeVariables(details.outerVariables);
        this.inlineFunctionStack.pop();
        return result;
    }

    public static Expression makeInlineFunctionValue(XPathParser p, AnnotationList annotations, InlineFunctionDetails details, List<UserFunctionParameter> params, SequenceType resultType, Expression body) {
        Expression result;
        List<UserFunctionParameter> implicitParams;
        int arity = params.size();
        UserFunction uf = new UserFunction();
        uf.setFunctionName(new StructuredQName("anon", "http://ns.saxonica.com/anonymous-type", "f_" + uf.hashCode()));
        uf.setPackageData(p.getStaticContext().getPackageData());
        uf.setBody(body);
        uf.setAnnotations(annotations);
        uf.setResultType(resultType);
        uf.incrementReferenceCount();
        if (uf.getPackageData() instanceof StylesheetPackage) {
            StylesheetPackage pack = (StylesheetPackage)uf.getPackageData();
            Component comp = Component.makeComponent(uf, Visibility.PRIVATE, VisibilityProvenance.DEFAULTED, pack, pack);
            uf.setDeclaringComponent(comp);
        }
        if (!(implicitParams = details.implicitParams).isEmpty()) {
            int extraParams = implicitParams.size();
            int expandedArity = params.size() + extraParams;
            UserFunctionParameter[] paramArray = new UserFunctionParameter[expandedArity];
            for (int i = 0; i < params.size(); ++i) {
                paramArray[i] = params.get(i);
            }
            int k = params.size();
            for (UserFunctionParameter implicitParam : implicitParams) {
                paramArray[k++] = implicitParam;
            }
            uf.setParameterDefinitions(paramArray);
            SlotManager stackFrame = p.getStaticContext().getConfiguration().makeSlotManager();
            for (int i = 0; i < expandedArity; ++i) {
                int slot = stackFrame.allocateSlotNumber(paramArray[i].getVariableQName());
                paramArray[i].setSlotNumber(slot);
            }
            ExpressionTool.allocateSlots(body, expandedArity, stackFrame);
            uf.setStackFrameMap(stackFrame);
            result = new UserFunctionReference(uf);
            Expression[] partialArgs = new Expression[expandedArity];
            for (int i = 0; i < arity; ++i) {
                partialArgs[i] = null;
            }
            for (int ip = 0; ip < implicitParams.size(); ++ip) {
                LocalVariableReference var;
                UserFunctionParameter ufp = implicitParams.get(ip);
                LocalBinding binding = details.outerVariablesUsed.get(ip);
                if (binding instanceof TemporaryXSLTVariableBinding) {
                    var = new LocalVariableReference(binding);
                    ((TemporaryXSLTVariableBinding)binding).declaration.registerReference(var);
                } else {
                    var = new LocalVariableReference(binding);
                }
                var.setStaticType(binding.getRequiredType(), null, 0);
                ufp.setRequiredType(binding.getRequiredType());
                partialArgs[ip + arity] = var;
            }
            result = new PartialApply(result, partialArgs);
        } else {
            UserFunctionParameter[] paramArray = params.toArray(new UserFunctionParameter[0]);
            uf.setParameterDefinitions(paramArray);
            SlotManager stackFrame = p.getStaticContext().getConfiguration().makeSlotManager();
            for (UserFunctionParameter param : paramArray) {
                stackFrame.allocateSlotNumber(param.getVariableQName());
            }
            ExpressionTool.allocateSlots(body, params.size(), stackFrame);
            uf.setStackFrameMap(stackFrame);
            result = new UserFunctionReference(uf);
        }
        if (uf.getPackageData() instanceof StylesheetPackage) {
            ((StylesheetPackage)uf.getPackageData()).addComponent(uf.getDeclaringComponent());
        }
        return result;
    }

    @Override
    public Expression parseSimpleInlineFunction(XPathParser p) throws XPathException {
        p.checkSyntaxExtensions("simple inline function");
        p.checkHofFeature();
        Tokenizer t = p.getTokenizer();
        int offset = t.currentTokenStartOffset;
        InlineFunctionDetails details = new InlineFunctionDetails();
        details.outerVariables = new Stack();
        for (LocalBinding lb : p.getRangeVariables()) {
            details.outerVariables.push(lb);
        }
        details.outerVariablesUsed = new ArrayList<LocalBinding>(4);
        details.implicitParams = new ArrayList<UserFunctionParameter>(4);
        this.inlineFunctionStack.push(details);
        p.setRangeVariables(new Stack<LocalBinding>());
        p.nextToken();
        ArrayList<UserFunctionParameter> params = new ArrayList<UserFunctionParameter>(8);
        SequenceType resultType = SequenceType.ANY_SEQUENCE;
        StructuredQName argQName = new StructuredQName("saxon", "http://saxon.sf.net/", "dot");
        UserFunctionParameter arg = new UserFunctionParameter();
        arg.setRequiredType(SequenceType.SINGLE_ITEM);
        arg.setVariableQName(argQName);
        arg.setSlotNumber(0);
        params.add(arg);
        Expression body = p.parseExpression();
        p.expect(215);
        t.lookAhead();
        p.nextToken();
        body.setRetainedStaticContext(p.getStaticContext().makeRetainedStaticContext());
        LocalVariableReference ref = new LocalVariableReference(arg);
        body = new ForEach(ref, body);
        Expression result = HofParserExtension.makeInlineFunctionValue(p, AnnotationList.EMPTY, details, params, resultType, body);
        p.setLocation(result, offset);
        p.setRangeVariables(details.outerVariables);
        this.inlineFunctionStack.pop();
        return result;
    }

    @Override
    public Expression makeCurriedFunction(XPathParser parser, int offset, StructuredQName name, Expression[] args, IntSet placeMarkers) throws XPathException {
        SymbolicName.F sn;
        StaticContext env = parser.getStaticContext();
        FunctionLibrary lib = env.getFunctionLibrary();
        Function target = lib.getFunctionItem(sn = new SymbolicName.F(name, args.length), env);
        if (target == null) {
            return parser.reportMissingFunction(offset, name, args, new ArrayList<String>());
        }
        Expression targetExp = HofParserExtension.makeNamedFunctionReference(name, target);
        parser.setLocation(targetExp, offset);
        return HofParserExtension.curryFunction(targetExp, args, placeMarkers);
    }

    public static Expression curryFunction(Expression functionExp, Expression[] args, IntSet placeMarkers) {
        IntIterator ii = placeMarkers.iterator();
        while (ii.hasNext()) {
            args[ii.next()] = null;
        }
        return new PartialApply(functionExp, args);
    }

    @Override
    public LocalBinding findOuterRangeVariable(XPathParser p, StructuredQName qName) {
        return HofParserExtension.findOuterRangeVariable(qName, this.inlineFunctionStack, p.getStaticContext());
    }

    public static LocalBinding findOuterRangeVariable(StructuredQName qName, Stack<InlineFunctionDetails> inlineFunctionStack, StaticContext env) {
        LocalBinding b2 = HofParserExtension.findOuterXPathRangeVariable(qName, inlineFunctionStack);
        if (b2 != null) {
            return b2;
        }
        if (env instanceof ExpressionContext && !inlineFunctionStack.isEmpty()) {
            b2 = HofParserExtension.findOuterXSLTVariable(qName, inlineFunctionStack, env);
        }
        return b2;
    }

    private static LocalBinding findOuterXPathRangeVariable(StructuredQName qName, Stack<InlineFunctionDetails> inlineFunctionStack) {
        for (int s = inlineFunctionStack.size() - 1; s >= 0; --s) {
            InlineFunctionDetails details = (InlineFunctionDetails)inlineFunctionStack.get(s);
            Stack<LocalBinding> outerVariables = details.outerVariables;
            for (int v = outerVariables.size() - 1; v >= 0; --v) {
                LocalBinding b2 = (LocalBinding)outerVariables.elementAt(v);
                if (!b2.getVariableQName().equals(qName)) continue;
                for (int bs = s; bs <= inlineFunctionStack.size() - 1; ++bs) {
                    details = (InlineFunctionDetails)inlineFunctionStack.get(bs);
                    boolean found = false;
                    for (int p = 0; p < details.outerVariablesUsed.size() - 1; ++p) {
                        if (details.outerVariablesUsed.get(p) != b2) continue;
                        b2 = details.implicitParams.get(p);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    details.outerVariablesUsed.add(b2);
                    UserFunctionParameter ufp = new UserFunctionParameter();
                    ufp.setVariableQName(qName);
                    ufp.setRequiredType(b2.getRequiredType());
                    details.implicitParams.add(ufp);
                    b2 = ufp;
                }
                return b2;
            }
            LocalBinding b2 = HofParserExtension.bindParametersInNestedFunctions(qName, inlineFunctionStack, s);
            if (b2 == null) continue;
            return b2;
        }
        return null;
    }

    private static LocalBinding bindParametersInNestedFunctions(StructuredQName qName, Stack<InlineFunctionDetails> inlineFunctionStack, int start) {
        InlineFunctionDetails details = (InlineFunctionDetails)inlineFunctionStack.get(start);
        List<UserFunctionParameter> params = details.implicitParams;
        for (UserFunctionParameter param : params) {
            if (!param.getVariableQName().equals(qName)) continue;
            LocalBinding b2 = param;
            for (int bs = start + 1; bs <= inlineFunctionStack.size() - 1; ++bs) {
                details = (InlineFunctionDetails)inlineFunctionStack.get(bs);
                boolean found = false;
                for (int p = 0; p < details.outerVariablesUsed.size() - 1; ++p) {
                    if (details.outerVariablesUsed.get(p) != param) continue;
                    b2 = details.implicitParams.get(p);
                    found = true;
                    break;
                }
                if (found) continue;
                details.outerVariablesUsed.add(param);
                UserFunctionParameter ufp = new UserFunctionParameter();
                ufp.setVariableQName(qName);
                ufp.setRequiredType(param.getRequiredType());
                details.implicitParams.add(ufp);
                b2 = ufp;
            }
            if (b2 == null) continue;
            return b2;
        }
        return null;
    }

    private static LocalBinding findOuterXSLTVariable(StructuredQName qName, Stack<InlineFunctionDetails> inlineFunctionStack, StaticContext env) {
        SourceBinding decl = ((ExpressionContext)env).getStyleElement().bindLocalVariable(qName);
        if (decl != null) {
            LocalBinding innermostBinding;
            InlineFunctionDetails details = (InlineFunctionDetails)inlineFunctionStack.get(0);
            boolean found = false;
            for (int p = 0; p < details.outerVariablesUsed.size(); ++p) {
                if (!details.outerVariablesUsed.get(p).getVariableQName().equals(qName)) continue;
                found = true;
                break;
            }
            if (!found) {
                details.outerVariablesUsed.add(new TemporaryXSLTVariableBinding(decl));
                UserFunctionParameter ufp = new UserFunctionParameter();
                ufp.setVariableQName(qName);
                ufp.setRequiredType(decl.getInferredType(true));
                details.implicitParams.add(ufp);
            }
            if ((innermostBinding = HofParserExtension.bindParametersInNestedFunctions(qName, inlineFunctionStack, 0)) != null) {
                return innermostBinding;
            }
        }
        return null;
    }

    @Override
    public Expression createDynamicCurriedFunction(XPathParser p, Expression functionItem, ArrayList<Expression> args, IntSet placeMarkers) {
        Expression[] arguments = new Expression[args.size()];
        args.toArray(arguments);
        Expression result = HofParserExtension.curryFunction(functionItem, arguments, placeMarkers);
        p.setLocation(result, p.getTokenizer().currentTokenStartOffset);
        return result;
    }

    @Override
    public void handleExternalFunctionDeclaration(XQueryParser p, XQueryFunction func) throws XPathException {
        Function ext;
        QueryModule qenv = (QueryModule)p.getStaticContext();
        SymbolicName.F fName = new SymbolicName.F(func.getFunctionName(), func.getNumberOfArguments());
        if (!qenv.getFunctionLibrary().isAvailable(fName)) {
            p.grumble("External function " + fName + " is not available", "XPST0017");
        }
        if ((ext = qenv.getFunctionLibrary().getFunctionItem(fName, qenv)) == null) {
            p.grumble("External function " + fName + " is not available", "XPST0017");
        } else {
            TypeHierarchy th = qenv.getConfiguration().getTypeHierarchy();
            if (!ext.getFunctionItemType().getResultType().isSameType(func.getResultType(), th)) {
                p.grumble("The declared return type of the external function (" + ext.getFunctionItemType().getResultType() + ") does not match the return type of the actual function (" + func.getResultType());
            }
            for (int i = 0; i < ext.getArity(); ++i) {
                if (ext.getFunctionItemType().getArgumentTypes()[i].isSameType(func.getArgumentTypes()[i], th)) continue;
                p.grumble("The declared type of argument " + i + " of the external function (" + ext.getFunctionItemType().getArgumentTypes()[i] + ") does not match the argument type of the actual function (" + func.getArgumentTypes()[i]);
            }
        }
    }

    public static class TemporaryXSLTVariableBinding
    implements LocalBinding {
        SourceBinding declaration;

        public TemporaryXSLTVariableBinding(SourceBinding decl) {
            this.declaration = decl;
        }

        @Override
        public SequenceType getRequiredType() {
            return this.declaration.getInferredType(true);
        }

        @Override
        public Sequence<?> evaluateVariable(XPathContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGlobal() {
            return false;
        }

        @Override
        public boolean isAssignable() {
            return false;
        }

        @Override
        public int getLocalSlotNumber() {
            return 0;
        }

        @Override
        public StructuredQName getVariableQName() {
            return this.declaration.getVariableQName();
        }

        @Override
        public void addReference(VariableReference ref, boolean isLoopingReference) {
        }

        @Override
        public IntegerValue[] getIntegerBoundsForVariable() {
            return null;
        }

        @Override
        public void setIndexedVariable() {
        }

        @Override
        public boolean isIndexedVariable() {
            return false;
        }
    }

    public static class InlineFunctionDetails {
        Stack<LocalBinding> outerVariables;
        List<LocalBinding> outerVariablesUsed;
        List<UserFunctionParameter> implicitParams;
    }
}

