/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.net;

import ch.e2e.net.FileServerConstants;
import ch.e2e.net.FileServerInputStream;
import ch.e2e.net.FileServerOutput;
import ch.e2e.net.FileServerOutputStream;
import ch.e2e.net.Logging;
import ch.e2e.net.TimeoutException;
import java.io.IOException;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;

public class FileServer
implements Logging,
FileServerConstants {
    private Socket client;
    private FileServerInputStream in;
    private FileServerOutputStream out;
    private long timeout = 120000L;
    private boolean timeoutReached = false;

    public FileServer(Socket client, FileServerOutput output) {
        this.client = client;
        try {
            this.in = new FileServerInputStream(client.getInputStream(), output);
            this.out = new FileServerOutputStream(client.getOutputStream(), output);
        }
        catch (IOException e) {
            if (output != null) {
                output.log("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            }
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "<init>", e);
        }
    }

    public void setOutput(FileServerOutput output) {
        this.in.setOutput(output);
        this.out.setOutput(output);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Object obj) throws IOException {
        this.out.writeObject(obj);
        this.timeoutReached = false;
        Timer timeoutTimer = new Timer();
        timeoutTimer.schedule((TimerTask)new TimeoutTask(), this.timeout);
        String transferMessage = null;
        try {
            transferMessage = this.in.readProtocolLine();
        }
        catch (IOException ioEx) {
            if (this.timeoutReached) {
                this.close();
                throw new TimeoutException(this.timeout);
            }
        }
        finally {
            timeoutTimer.cancel();
        }
        if (transferMessage.equals("[TRANSFER_ABORTED]")) {
            throw new IOException("Transfer of '" + obj + "' aborted.");
        }
        if (!transferMessage.equals("[TRANSFER_SUCCESSFULL]")) {
            throw new IOException("Unknow error tranfering '" + obj + "'.");
        }
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object readObject() throws IOException {
        Object obj = this.in.readObject();
        this.out.writeProtocolLine("[TRANSFER_SUCCESSFULL]");
        return obj;
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        @Override
        public void run() {
            try {
                FileServer.this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            FileServer.this.timeoutReached = true;
        }
    }
}

