/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.parameter;

import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import ch.e2e.builder.trace.testcase.parameter.ParameterFactory;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import ch.e2e.builder.trace.tools.NamespacesManager;
import ch.e2e.builder.trace.tools.TypeMapper;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ArrayParameter
extends RecordParameter {
    private static final Matcher MATCHER = Pattern.compile("\\w*:(\\w*)\\[\\d*\\]").matcher("");
    private String typeName;
    private int size = -1;
    private int nameIndex = 0;

    public ArrayParameter(Element parameterElement, int type, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        this(parameterElement, type, parent, definitionHolder, false);
    }

    public ArrayParameter(Element parameterElement, int type, RecordParameter parent, ParameterDefinitionHolder definitionHolder, boolean namespaceAware) {
        super(parameterElement, type, false, parent, definitionHolder, namespaceAware);
        String attributeName;
        NamespacesManager namespacesManager = this.getDefinitionHolder().getNamespacesManager();
        switch (this.getSoapVersion()) {
            case SOAP11: {
                attributeName = "arrayType";
                break;
            }
            case SOAP12: {
                attributeName = "itemType";
                break;
            }
            default: {
                throw new IllegalStateException("Neither SOAP 1.1 nor SOAP 1.2");
            }
        }
        if (namespaceAware) {
            String soapEncodingNamespaceUri = namespacesManager.getSoapEncodingNamespaceUri();
            this.typeName = parameterElement.getAttributeNS(soapEncodingNamespaceUri, attributeName);
        } else {
            this.typeName = parameterElement.getAttribute(attributeName);
        }
        MATCHER.reset(this.typeName);
        if (MATCHER.matches()) {
            this.typeName = MATCHER.group(1);
        }
        ParameterFactory.createParameter(parameterElement.getChildNodes(), this.items, this.names, true, this, definitionHolder, namespaceAware);
        if (!this.isNull()) {
            this.size = this.items.size();
            for (int i = 0; i < this.size; ++i) {
                Parameter parameter = (Parameter)this.items.get(i);
                if (!parameter.getName().equals("item")) continue;
                String newName = "item" + String.valueOf(this.nameIndex++);
                this.names.set(i, newName);
                parameter.setName(newName);
            }
        }
    }

    private ArrayParameter(String name, int type, String typeName, String namespace, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        super(name, type, false, namespace, parent, definitionHolder);
        this.typeName = typeName;
    }

    @Override
    public ArrayParameter copy(RecordParameter parent) {
        ArrayParameter result = new ArrayParameter(this.getName(), this.getType(), this.typeName, this.getNamespace(), parent, this.getDefinitionHolder());
        result.setValue(this.getValue());
        if (!this.isNull()) {
            result.size = this.items.size();
            result.setNil(false);
            for (Parameter parameter : this.items) {
                result.addItem(parameter.copy(result));
            }
        }
        return result;
    }

    @Override
    public String getDiagramName() {
        return null;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isArrayItem() {
        return false;
    }

    @Override
    public String getTypeName() {
        return this.size == -1 ? this.typeName + "[]" : this.typeName + '[' + this.size + ']';
    }

    public void addItem() {
        if (this.size == -1) {
            this.create();
        }
        ++this.size;
        RecordParameter parameter = (RecordParameter)this.getDefinitionHolder().findDefinition(this.getPath());
        int length = parameter.getChildCount();
        for (int i = 0; i < length; ++i) {
            Parameter item = ((Parameter)parameter.getChild(i)).createEmptyParameter(this);
            item.setName(item.getName() + String.valueOf(this.nameIndex++));
            this.addItem(item);
        }
    }

    public Parameter insertBefore(Parameter referenceItem) {
        int index = this.getIndexOfChild(referenceItem);
        return this.insertItem(index);
    }

    public Parameter insertBehind(Parameter referenceItem) {
        int index = this.getIndexOfChild(referenceItem) + 1;
        return this.insertItem(index);
    }

    @Override
    public void removeItem(Parameter parameter) {
        super.removeItem(parameter);
        this.size = this.items.size();
    }

    @Override
    public void create() {
        this.size = 0;
        this.nameIndex = 0;
        this.names.clear();
        this.items.clear();
        this.setNil(false);
    }

    @Override
    public Element createSOAPParameter(Document document) {
        Element parameter = document.createElement(this.getName());
        this.createArrayAttributes(parameter, this.getChildCount());
        ParameterFactory.appendSOAPChilds(this.items, parameter, document);
        return parameter;
    }

    @Override
    public Element createEmptySOAPParameter(Document document) {
        Element parameter = document.createElement(this.getName());
        this.createArrayAttributes(parameter, 0);
        parameter.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
        return parameter;
    }

    private void createArrayAttributes(Element parameter, int arraySize) {
        NamespacesManager namespacesManager = this.getDefinitionHolder().getNamespacesManager();
        String uri = namespacesManager.getSoapEncodingNamespaceUri();
        String soapencPrefix = namespacesManager.getPrefix(namespacesManager.getSoapEncodingNamespaceUri());
        switch (this.getSoapVersion()) {
            case SOAP11: {
                String type = (this.getPrefix() == null ? TypeMapper.bridgeType2XSD(this.typeName) : this.getPrefix() + ':' + this.typeName) + "[" + arraySize + "]";
                parameter.setAttributeNS(uri, "soapenc:arrayType", type);
                break;
            }
            case SOAP12: {
                String type = this.getPrefix() == null ? TypeMapper.bridgeType2XSD(this.typeName) : this.getPrefix() + ':' + this.typeName;
                parameter.setAttributeNS(uri, soapencPrefix + ":" + "itemType", type);
                if (arraySize <= -1) break;
                parameter.setAttributeNS(uri, soapencPrefix + ":" + "arraySize", String.valueOf(arraySize));
            }
        }
        parameter.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "soapenc:Array");
    }

    @Override
    String getOriginalType() {
        return "Base Types.Array";
    }

    @Override
    String[] getPath() {
        RecordParameter parent = this.getParent();
        if (parent != null && parent.isRecursive()) {
            String[] path = parent.getPath();
            String[] newPath = Arrays.copyOf(path, path.length + 1);
            newPath[path.length] = this.getName();
            return newPath;
        }
        return super.getPath();
    }

    @Override
    void addExtendedAttributes(Element element) {
        switch (this.getSoapVersion()) {
            case SOAP11: {
                element.setAttribute("arrayType", this.typeName);
                break;
            }
            case SOAP12: {
                element.setAttribute("itemType", this.typeName);
                if (this.size <= -1) break;
                element.setAttribute("arraySize", String.valueOf(this.size));
            }
        }
    }

    @Override
    public Parameter createEmptyParameter(RecordParameter parent) {
        return new ArrayParameter(this.getName(), this.getType(), this.typeName, this.getNamespace(), parent, this.getDefinitionHolder());
    }

    @Override
    public Element createParameterElement(Document document) {
        Element parameter = super.createParameterElement(document);
        parameter.setAttribute("type", "Base Types.Array");
        this.addExtendedAttributes(parameter);
        return parameter;
    }

    @Override
    public void setValue(Object value) {
        this.size = -1;
        super.setValue(value);
    }

    @Override
    public Parameter getParameter(String name) {
        Parameter result = name.startsWith("item") ? super.getParameter("item") : super.getParameter(name);
        return result;
    }

    private Parameter insertItem(int index) {
        ++this.size;
        Parameter item = null;
        RecordParameter parameter = (RecordParameter)this.getDefinitionHolder().findDefinition(this.getPath());
        int length = parameter.getChildCount();
        if (length == 1) {
            item = ((Parameter)parameter.getChild(0)).createEmptyParameter(this);
            item.setName(item.getName() + String.valueOf(this.nameIndex++));
            this.addItem(index, item);
        }
        return item;
    }

    @Override
    public boolean differsFrom(Parameter other) {
        return !(other instanceof ArrayParameter) || !this.typeName.equals(((ArrayParameter)other).typeName) || super.differsFrom(other);
    }
}

