/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.swing.tree;

import ch.e2e.builder.trace.testcase.TreeObject;
import ch.e2e.swing.model.AbstractTreeModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public class TreeModelSearcher
implements TreeModelListener {
    private final AbstractTreeModel model;
    private List<Object> nodes;
    private List<Object> matches;
    private Matcher matcher;
    private String searchString = "";
    private boolean caseSensitive = false;
    private ChangeType changeType = ChangeType.MATCH_NONE;
    private EventListenerList listeners = new EventListenerList();

    public TreeModelSearcher(AbstractTreeModel model) {
        this.model = model;
        this.matches = new ArrayList<Object>();
        model.addTreeModelListener((TreeModelListener)this);
    }

    public List<Object> getMatches() {
        return this.matches;
    }

    public Object getMatch(int index) {
        return this.matches.get(index);
    }

    public int getMatchCount() {
        return this.matches.size();
    }

    public boolean hasMatches() {
        return !this.matches.isEmpty();
    }

    public List<Object> search(String searchString) {
        this.setSearchString(searchString);
        return this.getMatches();
    }

    public void setSearchString(String searchString) {
        this.loadModel();
        this.setChangeType(searchString);
        this.searchString = searchString;
        this.setMatcher();
        this.refilter();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        if (this.caseSensitive == caseSensitive) {
            this.changeType = ChangeType.UNCHANGED;
        } else {
            this.caseSensitive = caseSensitive;
            this.changeType = caseSensitive ? ChangeType.NARROWED : ChangeType.WIDENED;
            this.setMatcher();
            this.refilter();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(ChangeListener.class, listener);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.reloadModel();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.reloadModel();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.reloadModel();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.reloadModel();
    }

    private void setMatcher() {
        this.matcher = Pattern.compile(Pattern.quote(this.searchString), this.getPatternFlags()).matcher("");
    }

    private void setChangeType(String searchString) {
        this.changeType = searchString == null || searchString.isEmpty() ? ChangeType.MATCH_NONE : (this.searchString == null || this.searchString.isEmpty() ? ChangeType.CHANGED : (this.searchString.matches(searchString) ? ChangeType.UNCHANGED : (searchString.contains(this.searchString) ? ChangeType.NARROWED : (this.searchString.contains(searchString) ? ChangeType.WIDENED : ChangeType.CHANGED))));
    }

    private void refilter() {
        switch (this.changeType) {
            case CHANGED: {
                this.changed();
                break;
            }
            case MATCH_ALL: {
                this.matchAll();
                break;
            }
            case MATCH_NONE: {
                this.matchNone();
                break;
            }
            case NARROWED: {
                this.narrowed();
                break;
            }
            case WIDENED: {
                this.widened();
            }
        }
        this.fireChangeEvent();
    }

    private void matchAll() {
        this.matches.clear();
        this.matches.addAll(this.nodes);
    }

    private void matchNone() {
        this.matches.clear();
    }

    private void changed() {
        this.matches.clear();
        for (Object node : this.nodes) {
            if (!this.accept(node)) continue;
            this.matches.add(node);
        }
    }

    private void narrowed() {
        for (int i = this.matches.size() - 1; i > -1; --i) {
            if (this.accept(this.matches.get(i))) continue;
            this.matches.remove(i);
        }
    }

    private void widened() {
        if (this.nodes != null) {
            for (Object node : this.nodes) {
                if (this.matches.contains(node) || !this.accept(node)) continue;
                this.matches.add(node);
            }
        }
    }

    private boolean accept(Object node) {
        return node instanceof TreeObject && this.matcher.reset(node.toString()).find();
    }

    private void loadModel() {
        if (this.nodes == null) {
            this.nodes = new ArrayList<Object>();
            Iterator iterator = this.getModelIterator();
            while (iterator.hasNext()) {
                this.nodes.add(iterator.next());
            }
            this.matches.addAll(this.nodes);
        }
    }

    private Iterator getModelIterator() {
        return this.model.preorderIterator(this.model.getRoot());
    }

    private void reloadModel() {
        if (this.nodes != null) {
            this.nodes.clear();
            this.matches.clear();
            Iterator iterator = this.getModelIterator();
            while (iterator.hasNext()) {
                this.nodes.add(iterator.next());
            }
            this.changeType = ChangeType.CHANGED;
            this.refilter();
        }
    }

    private int getPatternFlags() {
        return this.caseSensitive ? 0 : 2;
    }

    private void fireChangeEvent() {
        if (this.changeType != ChangeType.UNCHANGED) {
            for (ChangeListener listener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
                listener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    private static enum ChangeType {
        CHANGED,
        MATCH_ALL,
        MATCH_NONE,
        NARROWED,
        UNCHANGED,
        WIDENED;

    }
}

