/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.abstracts.DoTransactionEvent;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.traceviewer.execute.AsyncTraceAction;
import ch.e2e.builder.traceviewer.execute.rest.RequestTransaction;
import ch.e2e.builder.traceviewer.execute.soap.AsynchronousTransaction;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import ch.e2e.builder.traceviewer.testcase.AbstractAsynchronousTestcase;
import ch.e2e.event.EventController;
import java.util.EventObject;
import java.util.function.BiFunction;

public class AsyncTraceTransactionFactory {
    private AsyncTraceTransactionFactory() {
    }

    public static void fireTransaction(Object source, AsyncTraceAction action, E2EBuilderModule traceViewer, AbstractAsyncTestcaseFolder testcaseFolder) {
        EventController.fire((EventObject)AsyncTraceTransactionFactory.newTransaction(source, action, traceViewer, testcaseFolder));
    }

    public static <T> void fireTransaction(Object source, AsyncTraceAction action, E2EBuilderModule traceViewer, AbstractAsyncTestcaseFolder testcaseFolder, T requestBody) {
        EventController.fire((EventObject)AsyncTraceTransactionFactory.newTransaction(source, action, traceViewer, testcaseFolder, requestBody));
    }

    public static void fireTransaction(Object source, AsyncTraceAction action, E2EBuilderModule traceViewer, AbstractAsynchronousTestcase testcase) {
        EventController.fire((EventObject)AsyncTraceTransactionFactory.newTransaction(source, action, traceViewer, testcase));
    }

    public static DoTransactionEvent newTransaction(Object source, AsyncTraceAction action, E2EBuilderModule traceViewer, AbstractAsyncTestcaseFolder testcaseFolder) {
        return AsyncTraceTransactionFactory.newTransaction(source, action, traceViewer, (TestcaseContainer)testcaseFolder, null, AbstractAsyncTestcaseFolder.class, testcaseFolder.isUseAsyncRest());
    }

    public static <T> DoTransactionEvent newTransaction(Object source, AsyncTraceAction action, E2EBuilderModule traceViewer, AbstractAsyncTestcaseFolder testcaseFolder, T requestBody) {
        return AsyncTraceTransactionFactory.newTransaction(source, action, traceViewer, (TestcaseContainer)testcaseFolder, requestBody, AbstractAsyncTestcaseFolder.class, testcaseFolder.isUseAsyncRest());
    }

    public static DoTransactionEvent newTransaction(Object source, AsyncTraceAction action, E2EBuilderModule traceViewer, AbstractAsynchronousTestcase testcase) {
        return AsyncTraceTransactionFactory.newTransaction(source, action, traceViewer, (TestcaseContainer)testcase, null, AbstractAsynchronousTestcase.class, ((AbstractAsyncTestcaseFolder)testcase.getParent()).isUseAsyncRest());
    }

    private static <T> DoTransactionEvent newTransaction(Object source, AsyncTraceAction action, E2EBuilderModule traceViewer, TestcaseContainer testcaseContainer, T requestBody, Class<?> testcaseContainerClass, boolean isUseAsyncRest) {
        try {
            BiFunction<AsyncTraceAction, String, String> buildClassName = isUseAsyncRest ? AsyncTraceTransactionFactory::buildRestClassName : AsyncTraceTransactionFactory::buildSoapClassName;
            E2EBuilderTransaction transaction = AsyncTraceTransactionFactory.newTransaction(buildClassName.apply(action, "Transaction"), traceViewer);
            Object request = AsyncTraceTransactionFactory.newRequest(buildClassName.apply(action, "Request"), testcaseContainerClass, testcaseContainer, requestBody);
            return new DoTransactionEvent(source, transaction, request);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static E2EBuilderTransaction newTransaction(String transactionClass, E2EBuilderModule traceViewer) throws ReflectiveOperationException {
        return (E2EBuilderTransaction)Class.forName(transactionClass).getConstructor(E2EBuilderModule.class).newInstance(traceViewer);
    }

    private static <T> Object newRequest(String requestClass, Class<?> testcaseContainerClass, TestcaseContainer testcaseContainer, T requestBody) throws ReflectiveOperationException {
        Object[] requestNewInstanceParams;
        Class[] requestConstructorParams;
        if (requestBody == null) {
            requestConstructorParams = new Class[]{testcaseContainerClass};
            requestNewInstanceParams = new Object[]{testcaseContainer};
        } else {
            requestConstructorParams = new Class[]{testcaseContainerClass, requestBody.getClass()};
            requestNewInstanceParams = new Object[]{testcaseContainer, requestBody};
        }
        return Class.forName(requestClass).getConstructor(requestConstructorParams).newInstance(requestNewInstanceParams);
    }

    private static String buildSoapClassName(AsyncTraceAction action, String className) {
        return AsyncTraceTransactionFactory.buildClassName(AsynchronousTransaction.class, action, className);
    }

    private static String buildRestClassName(AsyncTraceAction action, String className) {
        return AsyncTraceTransactionFactory.buildClassName(RequestTransaction.class, action, className);
    }

    private static String buildClassName(Class<?> reference, AsyncTraceAction action, String className) {
        return String.format("%s.%s%s", reference.getPackage().getName(), action, className);
    }
}

