/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.hex.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.fife.ui.hex.swing.HexEditor;
import org.fife.ui.hex.swing.HexTableModel;

class HexTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private final HexEditor hexEditor;
    private HexTableModel model;
    private boolean showColumnHeader = true;
    int leadSelectionIndex;
    int anchorSelectionIndex;
    private static final Color ANTERNATING_CELL_COLOR = new Color(240, 240, 240);

    public HexTable(HexEditor hexEditor, HexTableModel hexTableModel) {
        super(hexTableModel);
        this.hexEditor = hexEditor;
        this.model = hexTableModel;
        this.enableEvents(8L);
        this.setAutoResizeMode(0);
        this.setFont(new Font("Monospaced", 0, this.getFont().getSize()));
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(1);
        this.setDefaultEditor(Object.class, new CellEditor());
        this.setDefaultRenderer(Object.class, new CellRenderer());
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Font font = UIManager.getFont("TableHeader.font");
        FontMetrics fontMetrics2 = hexEditor.getFontMetrics(font);
        int n = fontMetrics.stringWidth("wwww");
        n = Math.max(n, fontMetrics2.stringWidth("+999"));
        int n2 = fontMetrics.stringWidth("wwwwwwwwwwwwwwwwww");
        n2 = Math.max(n2, fontMetrics2.stringWidth("+99999999999999999"));
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            if (i < 16) {
                tableColumn.setPreferredWidth(n);
                continue;
            }
            tableColumn.setPreferredWidth(n2);
        }
        this.setPreferredScrollableViewportSize(new Dimension(n * 16 + n2, 25 * this.getRowHeight()));
        this.leadSelectionIndex = 0;
        this.anchorSelectionIndex = 0;
    }

    public void setShowColumnHeader(boolean bl) {
        this.showColumnHeader = bl;
    }

    @Override
    public JTableHeader getTableHeader() {
        return this.showColumnHeader ? super.getTableHeader() : null;
    }

    private int adjustColumn(int n, int n2) {
        if (n2 < 0) {
            return 0;
        }
        if (n == this.getRowCount() - 1) {
            int n3 = this.model.getByteCount() % 16;
            if (n3 == 0) {
                n3 = 16;
            }
            if (n3 < 16) {
                return Math.min(n2, this.model.getByteCount() % 16 - 1);
            }
        }
        return Math.min(n2, this.getColumnCount() - 1 - 1);
    }

    public int cellToOffset(int n, int n2) {
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 > 15) {
            return -1;
        }
        int n3 = n * 16 + n2;
        return n3 >= 0 && n3 < this.model.getByteCount() ? n3 : -1;
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        n2 = this.adjustColumn(n, n2);
        if (n < 0) {
            n = 0;
        }
        this.repaintSelection();
        if (bl2) {
            this.leadSelectionIndex = this.cellToOffset(n, n2);
        } else {
            this.anchorSelectionIndex = this.leadSelectionIndex = this.cellToOffset(n, n2);
        }
        if (this.getAutoscrolls()) {
            this.ensureCellIsVisible(n, n2);
        }
        this.repaintSelection();
    }

    public void changeSelectionByOffset(int n, boolean bl) {
        n = Math.max(0, n);
        n = Math.min(n, this.model.getByteCount() - 1);
        int n2 = n / 16;
        int n3 = n % 16;
        this.changeSelection(n2, n3, false, bl);
    }

    @Override
    public void clearSelection() {
        if (this.anchorSelectionIndex > -1) {
            this.leadSelectionIndex = this.anchorSelectionIndex;
        } else {
            this.leadSelectionIndex = 0;
            this.anchorSelectionIndex = 0;
        }
        this.repaintSelection();
    }

    private void ensureCellIsVisible(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, n2, false);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public byte getByte(int n) {
        return this.model.getByte(n);
    }

    public int getByteCount() {
        return this.model.getByteCount();
    }

    public int getLargestSelectionIndex() {
        return Math.max(this.leadSelectionIndex, this.anchorSelectionIndex);
    }

    public int getSmallestSelectionIndex() {
        return Math.min(this.leadSelectionIndex, this.anchorSelectionIndex);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.hexEditor.isEditable() && this.cellToOffset(n, n2) > -1;
    }

    @Override
    public boolean isCellSelected(int n, int n2) {
        int n3 = this.cellToOffset(n, n2);
        if (n3 == -1) {
            return false;
        }
        int n4 = this.getSmallestSelectionIndex();
        int n5 = this.getLargestSelectionIndex();
        return n3 >= n4 && n3 <= n5;
    }

    public Point offsetToCell(int n) {
        if (n < 0 || n >= this.model.getByteCount()) {
            return new Point(-1, -1);
        }
        int n2 = n / 16;
        int n3 = n % 16;
        return new Point(n2, n3);
    }

    public void open(String string) throws IOException {
        this.model.setBytes(string);
    }

    public void open(InputStream inputStream) throws IOException {
        this.model.setBytes(inputStream);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Object object = this.getValueAt(n, n2);
        boolean bl = this.isCellSelected(n, n2);
        boolean bl2 = this.cellToOffset(n, n2) == this.leadSelectionIndex;
        return tableCellRenderer.getTableCellRendererComponent(this, object, bl, bl2, n, n2);
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    boolean bl = keyEvent.isShiftDown();
                    int n = Math.max(this.leadSelectionIndex - 1, 0);
                    this.changeSelectionByOffset(n, bl);
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    boolean bl = keyEvent.isShiftDown();
                    int n = Math.min(this.leadSelectionIndex + 1, this.model.getByteCount() - 1);
                    this.changeSelectionByOffset(n, bl);
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    boolean bl = keyEvent.isShiftDown();
                    int n = Math.max(this.leadSelectionIndex - 16, 0);
                    this.changeSelectionByOffset(n, bl);
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    boolean bl = keyEvent.isShiftDown();
                    int n = Math.min(this.leadSelectionIndex + 16, this.model.getByteCount() - 1);
                    this.changeSelectionByOffset(n, bl);
                    keyEvent.consume();
                    break;
                }
                case 34: {
                    boolean bl = keyEvent.isShiftDown();
                    int n = this.getVisibleRect().height / this.getRowHeight();
                    int n2 = Math.min(this.leadSelectionIndex + n * 16, this.model.getByteCount() - 1);
                    this.changeSelectionByOffset(n2, bl);
                    keyEvent.consume();
                    break;
                }
                case 33: {
                    boolean bl = keyEvent.isShiftDown();
                    int n = this.getVisibleRect().height / this.getRowHeight();
                    int n3 = Math.max(this.leadSelectionIndex - n * 16, 0);
                    this.changeSelectionByOffset(n3, bl);
                    keyEvent.consume();
                    break;
                }
                case 36: {
                    boolean bl = keyEvent.isShiftDown();
                    int n = this.leadSelectionIndex / 16 * 16;
                    this.changeSelectionByOffset(n, bl);
                    keyEvent.consume();
                    break;
                }
                case 35: {
                    boolean bl = keyEvent.isShiftDown();
                    int n = this.leadSelectionIndex / 16 * 16 + 15;
                    n = Math.min(n, this.model.getByteCount() - 1);
                    this.changeSelectionByOffset(n, bl);
                    keyEvent.consume();
                }
            }
        }
        super.processKeyEvent(keyEvent);
    }

    public boolean redo() {
        return this.model.redo();
    }

    void removeBytes(int n, int n2) {
        this.model.removeBytes(n, n2);
    }

    private void repaintSelection() {
        this.repaint();
    }

    public void replaceBytes(int n, int n2, byte[] byArray) {
        this.model.replaceBytes(n, n2, byArray);
    }

    public void setSelectedRows(int n, int n2) {
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getRowCount()) {
            throw new IllegalArgumentException();
        }
        int n3 = n * 16;
        int n4 = n2 * 16 + 15;
        this.changeSelectionByOffset(n3, false);
        this.changeSelectionByOffset(n4, true);
    }

    public void setSelectionByOffsets(int n, int n2) {
        n = Math.max(0, n);
        n = Math.min(n, this.model.getByteCount() - 1);
        this.repaintSelection();
        this.anchorSelectionIndex = n;
        this.leadSelectionIndex = n2;
        if (this.getAutoscrolls()) {
            int n3 = n2 / 16;
            int n4 = n2 % 16;
            n4 = this.adjustColumn(n3, n4);
            if (n3 < 0) {
                n3 = 0;
            }
            this.ensureCellIsVisible(n3, n4);
        }
        this.repaintSelection();
    }

    public boolean undo() {
        return this.model.undo();
    }

    private static class EditorDocumentFilter
    extends DocumentFilter {
        private EditorDocumentFilter() {
        }

        private boolean ensureByteRepresented(String string) {
            try {
                int n = Integer.parseInt(string, 16);
                if (n < 0 || n > 255) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return false;
            }
            return true;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            Document document = filterBypass.getDocument();
            String string2 = document.getText(0, n) + string + document.getText(n, document.getLength() - n);
            if (this.ensureByteRepresented(string2)) {
                filterBypass.insertString(n, string2, attributeSet);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            Document document = filterBypass.getDocument();
            String string2 = document.getText(0, n) + string + document.getText(n + n2, document.getLength() - (n + n2));
            if (this.ensureByteRepresented(string2)) {
                filterBypass.replace(n, n2, string, attributeSet);
            }
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private Point highlight = new Point();

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.highlight.setLocation(-1, -1);
            if (n2 == jTable.getColumnCount() - 1 && HexTable.this.hexEditor.getHighlightSelectionInAsciiDump()) {
                int n3;
                int n4 = HexTable.this.getSmallestSelectionIndex();
                int n5 = HexTable.this.getLargestSelectionIndex();
                int n6 = n * 16;
                int n7 = n6 + 15;
                if (n4 <= n7 && n5 >= n6) {
                    n3 = Math.max(n4, n6) - n6;
                    int n8 = Math.min(n5, n7) - n6;
                    this.highlight.setLocation(n3, n8);
                }
                n3 = HexTable.this.hexEditor.getAlternateRowBG() && (n & 1) > 0 ? 1 : 0;
                this.setBackground(n3 != 0 ? ANTERNATING_CELL_COLOR : jTable.getBackground());
            } else if (!bl) {
                if ((HexTable.this.hexEditor.getAlternateRowBG() && (n & 1) > 0) ^ (HexTable.this.hexEditor.getAlternateColumnBG() && (n2 & 1) > 0)) {
                    this.setBackground(ANTERNATING_CELL_COLOR);
                } else {
                    this.setBackground(jTable.getBackground());
                }
            }
            return this;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n;
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.highlight.x > -1) {
                n = this.getFontMetrics(HexTable.this.getFont()).charWidth('w');
                graphics.setColor(HexTable.this.hexEditor.getHighlightSelectionInAsciiDumpColor());
                int n2 = this.getInsets().left + this.highlight.x * n;
                graphics.fillRect(n2, 0, (this.highlight.y - this.highlight.x + 1) * n, HexTable.this.getRowHeight());
            }
            graphics.setColor(this.getForeground());
            n = 2;
            String string = this.getText();
            if (string.length() == 1) {
                n += graphics.getFontMetrics().charWidth('w');
            }
            graphics.drawString(string, n, 11);
        }
    }

    private static class CellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private static final long serialVersionUID = 1L;

        public CellEditor() {
            super(new JTextField());
            AbstractDocument abstractDocument = (AbstractDocument)((JTextComponent)this.editorComponent).getDocument();
            abstractDocument.setDocumentFilter(new EditorDocumentFilter());
            this.getComponent().addFocusListener(this);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JTextField jTextField = (JTextField)this.getComponent();
            jTextField.selectAll();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public boolean stopCellEditing() {
            String string = (String)this.getCellEditorValue();
            if (string.length() == 0) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return false;
            }
            return super.stopCellEditing();
        }
    }
}

