/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.hex;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteBuffer {
    private byte[] buffer;

    public ByteBuffer(int n) {
        this.buffer = new byte[n];
    }

    public ByteBuffer(String string) throws IOException {
        this(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer(File file) throws IOException {
        int n = (int)file.length();
        if (n < 0) {
            throw new IOException("Negative file length: " + n);
        }
        this.buffer = new byte[n];
        if (n > 0) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            int n2 = 0;
            try {
                for (int i = 0; i < this.buffer.length && (n2 = bufferedInputStream.read(this.buffer, i, this.buffer.length - i)) > -1; i += n2) {
                }
            }
            finally {
                bufferedInputStream.close();
            }
        }
    }

    public ByteBuffer(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.buffer = new byte[4096];
        int n = 0;
        while ((n = inputStream.read(this.buffer, 0, this.buffer.length)) > -1) {
            byteArrayOutputStream.write(this.buffer, 0, n);
        }
        this.buffer = byteArrayOutputStream.toByteArray();
    }

    public byte getByte(int n) {
        return this.buffer[n];
    }

    public int getSize() {
        return this.buffer.length;
    }

    public void insertByte(int n, byte by) {
        byte[] byArray = new byte[this.buffer.length + 1];
        System.arraycopy(this.buffer, 0, byArray, 0, n);
        byArray[n] = by;
        System.arraycopy(this.buffer, n, byArray, n + 1, this.buffer.length - n);
        this.buffer = byArray;
    }

    public void insertBytes(int n, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        byte[] byArray2 = new byte[this.buffer.length + byArray.length];
        System.arraycopy(this.buffer, 0, byArray2, 0, n);
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        System.arraycopy(this.buffer, n, byArray2, n + byArray.length, this.buffer.length - n);
        this.buffer = byArray2;
    }

    public int read(int n, byte[] byArray) {
        if (byArray == null) {
            return -1;
        }
        int n2 = Math.min(byArray.length, this.getSize() - n);
        System.arraycopy(this.buffer, n, byArray, 0, n2);
        return n2;
    }

    public void remove(int n, int n2) {
        this.remove(n, n2, null);
    }

    public void remove(int n, int n2, byte[] byArray) {
        if (byArray != null) {
            System.arraycopy(this.buffer, n, byArray, 0, n2);
        }
        byte[] byArray2 = new byte[this.buffer.length - n2];
        System.arraycopy(this.buffer, 0, byArray2, 0, n);
        System.arraycopy(this.buffer, n + n2, byArray2, n, byArray2.length - n);
        this.buffer = byArray2;
    }

    public void setByte(int n, byte by) {
        this.buffer[n] = by;
    }
}

