/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.dom.DomUtilities;
import ch.e2e.swing.TreeObject;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.renderer.RendererPreferences;
import com.jidesoft.swing.CheckBoxTree;
import com.jidesoft.swing.CheckBoxTreeSelectionModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InspectionTreePanel
extends JPanel {
    private CheckBoxTree tree;

    public InspectionTreePanel() {
        super(new BorderLayout());
        InspectionTreeModel model = new InspectionTreeModel();
        this.tree = new CheckBoxTree((TreeModel)((Object)model));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer((TreeCellRenderer)new InspectionTreeCellRenderer(model));
        this.add(new JScrollPane((Component)this.tree));
    }

    public void setRoot(Document document, Collection<String> inspectedIds) {
        this.tree.getCheckBoxTreeSelectionModel().clearSelection();
        if (document == null) {
            this.tree.setModel(null);
        } else {
            this.tree.setModel((TreeModel)((Object)new InspectionTreeModel(document)));
            new InspectionsSelector(inspectedIds).visit(this.tree);
        }
    }

    public Collection<String> getInspectionIds() {
        return new InspectionIdsFinder(this.tree).getIds();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tree.setEnabled(enabled);
    }

    private static enum Type {
        Root,
        Unknown,
        Model,
        Package,
        Class,
        Activity,
        Action,
        IterationAction;

    }

    private static class InspectionIdsFinder {
        private Collection<String> ids = new ArrayList<String>();

        public InspectionIdsFinder(CheckBoxTree tree) {
            TreePath[] paths = tree.getCheckBoxTreeSelectionModel().getSelectionPaths();
            if (paths != null) {
                for (TreePath path : paths) {
                    this.visit((InspectionNode)path.getLastPathComponent());
                }
            }
        }

        private void visit(InspectionNode node) {
            int type = node.getType();
            if (type > Type.Activity.ordinal()) {
                this.ids.add(node.getId());
            }
            if (type != Type.IterationAction.ordinal()) {
                this.visitChildren(node);
            }
        }

        private void visitChildren(InspectionNode node) {
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.visit((InspectionNode)node.getChild(i));
            }
        }

        public Collection<String> getIds() {
            return this.ids;
        }
    }

    private static class InspectionsSelector {
        private final Collection<String> inspectedIds;
        private CheckBoxTreeSelectionModel selectionModel;

        public InspectionsSelector(Collection<String> inspectionIds) {
            this.inspectedIds = inspectionIds;
        }

        public void visit(CheckBoxTree tree) {
            this.selectionModel = tree.getCheckBoxTreeSelectionModel();
            Object root = tree.getModel().getRoot();
            if (root instanceof InspectionNode) {
                this.visit((InspectionNode)root);
            }
        }

        private void visit(InspectionNode node) {
            int type = node.getType();
            if (type > Type.Activity.ordinal() && this.inspectedIds.contains(node.getId())) {
                this.selectionModel.addSelectionPath(InspectionsSelector.getPathToRoot(node));
            }
            if (type != Type.IterationAction.ordinal()) {
                this.visitChildren(node);
            }
        }

        private void visitChildren(InspectionNode node) {
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.visit((InspectionNode)node.getChild(i));
            }
        }

        private static TreePath getPathToRoot(InspectionNode node) {
            ArrayList<InspectionNode> path = new ArrayList<InspectionNode>();
            do {
                path.add(node);
            } while ((node = node.getParent()) != null);
            Collections.reverse(path);
            return new TreePath(path.toArray());
        }
    }

    private static class InspectionNode
    implements TreeObject {
        private final String id;
        private String name;
        private final int type;
        private final InspectionNode parent;
        private final List<InspectionNode> children;

        public InspectionNode(Document document) {
            this.id = "root";
            this.name = "root";
            this.type = Type.Root.ordinal();
            this.parent = null;
            try {
                NodeList nodes = (NodeList)DomUtilities.evaluate((Node)document, (String)"//Model", (QName)XPathConstants.NODESET);
                int childCount = nodes.getLength();
                this.children = childCount == 0 ? Collections.emptyList() : new ArrayList();
                for (int i = 0; i < childCount; ++i) {
                    Element item = (Element)nodes.item(i);
                    if (item.getChildNodes().getLength() <= 0) continue;
                    this.children.add(new InspectionNode(this, item));
                }
            }
            catch (XPathExpressionException e) {
                throw new IllegalArgumentException(e);
            }
        }

        private InspectionNode(InspectionNode parent, Element element) {
            this.parent = parent;
            this.id = element.hasAttribute("id") ? element.getAttribute("id") : null;
            this.type = InspectionNode.getType(element.getNodeName());
            if ("IterationAction".equals(element.getNodeName())) {
                try {
                    this.name = "iterate over '" + DomUtilities.evaluate((Node)element, (String)"Action/@name", (QName)XPathConstants.STRING) + "'";
                }
                catch (XPathExpressionException e) {
                    throw new IllegalArgumentException(e);
                }
                this.children = Collections.emptyList();
            } else {
                int index;
                this.name = element.getAttribute("name");
                if (this.name.isEmpty() && this.id != null && (index = this.id.indexOf("...")) != -1) {
                    this.name = this.id.substring(0, index);
                }
                try {
                    NodeList nodes = (NodeList)DomUtilities.evaluate((Node)element, (String)"child::*", (QName)XPathConstants.NODESET);
                    int childCount = nodes.getLength();
                    this.children = childCount == 0 ? Collections.emptyList() : new ArrayList();
                    for (int i = 0; i < childCount; ++i) {
                        this.children.add(new InspectionNode(this, (Element)nodes.item(i)));
                    }
                }
                catch (XPathExpressionException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public InspectionNode getParent() {
            return this.parent;
        }

        public Object getChild(int index) {
            return this.children.get(index);
        }

        public int getChildCount() {
            return this.children.size();
        }

        public int getIndexOfChild(Object child) {
            return this.children.indexOf(child);
        }

        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            return this.getName();
        }

        private static int getType(String type) {
            try {
                return Type.valueOf(type).ordinal();
            }
            catch (IllegalArgumentException e) {
                return Type.Unknown.ordinal();
            }
        }
    }

    private static class InspectionTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private RendererPreferences preferences;

        private InspectionTreeCellRenderer(InspectionTreeModel model) {
            this.preferences = new RendererPreferences((AbstractTreeModel)model);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Icon[] icons = this.preferences.getIcons(((InspectionNode)value).getType(), leaf, expanded, selected);
            if (tree.isEnabled()) {
                this.setIcon(icons[0]);
            } else {
                this.setDisabledIcon(icons[1]);
            }
            return c;
        }
    }

    private static class InspectionTreeModel
    extends AbstractTreeModel {
        InspectionNode root;

        public InspectionTreeModel(Document document) {
            this();
            this.root = document == null ? null : new InspectionNode(document);
        }

        public InspectionTreeModel() {
            super("ch.e2e.builder.trace.properties.tree");
        }

        public InspectionNode getRoot() {
            return this.root;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public String getTypeString(int type) {
            String result = "treenode.unknown";
            switch (Type.values()[type]) {
                case Model: {
                    result = "treenode.testcase.folder";
                    break;
                }
                case Package: {
                    result = "treenode.package";
                    break;
                }
                case Class: {
                    result = "treenode.port";
                    break;
                }
                case Activity: {
                    result = "umlnode.activity.diagram";
                    break;
                }
                case Action: {
                    result = "umlnode.activity";
                    break;
                }
                case IterationAction: {
                    result = "umlnode.iterator.flow";
                }
            }
            return result;
        }
    }
}

