/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.rest;

import ch.e2e.builder.trace.testcase.LogFile;
import ch.e2e.builder.trace.testcase.RequestLogFile;
import ch.e2e.builder.trace.testcase.ResponseLogFile;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.traceviewer.execute.AsyncTraceAction;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import javax.ws.rs.core.MediaType;
import org.apache.commons.httpclient.Credentials;

public abstract class AsyncRequest<R> {
    private final String action;
    private final String method;
    private final URI uri;
    private final Credentials credentials;
    private R response;

    public AsyncRequest(AsyncTraceAction action, URI uri, Credentials credentials) {
        String _action = action.toString();
        this.action = Character.toLowerCase(_action.charAt(0)) + _action.substring(1);
        this.method = action.getHttpMethod();
        this.uri = uri;
        this.credentials = credentials;
    }

    public abstract TestcaseContainer getSource();

    public abstract Class<R> getResponseType();

    public abstract MediaType getAcceptedMediaType();

    public LogFile getRequestLog() {
        TestcaseContainer source = this.getSource();
        return source instanceof AbstractAsyncTestcaseFolder ? new RequestLogFile(source, ((AbstractAsyncTestcaseFolder)source).getHome(), this.getAction()) : null;
    }

    public LogFile getResponseLog() {
        TestcaseContainer source = this.getSource();
        return source instanceof AbstractAsyncTestcaseFolder ? new ResponseLogFile(source, ((AbstractAsyncTestcaseFolder)source).getHome(), this.getAction()) : null;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getAction() {
        return this.action;
    }

    public String getMethod() {
        return this.method;
    }

    public Object getBody() {
        return null;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public R getResponse() {
        return this.response;
    }

    public void setResponse(R response) {
        this.response = response;
    }

    public boolean isIgnoredStatusCode(int code) {
        return false;
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }
}

