/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.model;

import ch.e2e.builder.analyzer.model.TransactionLogObject;
import ch.e2e.builder.analyzer.model.TransactionLogRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TransactionLogTransaction
extends TransactionLogObject {
    private String id;
    private int duration = 0;
    private List<TransactionLogRequest> requests = new ArrayList<TransactionLogRequest>();
    private int numberOfLines = -1;

    public TransactionLogTransaction(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List<TransactionLogRequest> getRequests() {
        return this.requests;
    }

    public TransactionLogRequest getRequest(int index) {
        return this.requests.get(index);
    }

    public void addRequest(TransactionLogRequest request) {
        if (this.requests.add(request)) {
            request.setParent(this);
            this.duration += request.getDuration();
        }
    }

    @Override
    public String getName() {
        return this.getId();
    }

    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    public void setNumberOfLines(int numberOfLines) {
        this.numberOfLines = numberOfLines;
    }

    public long getDuration() {
        return this.duration;
    }

    public Date getStart() {
        return this.requests.get(0).getStart();
    }

    public Date getEnd() {
        int i = this.requests.size() - 1;
        return this.requests.get(i).getEnd();
    }

    @Override
    public Object getChild(int index) {
        return this.getRequests().get(index);
    }

    @Override
    public int getChildCount() {
        return this.getRequests().size();
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.getRequests().indexOf(child);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void delete() {
    }

    public String getOverview() {
        return "Information and statistics on transaction '" + this.getName() + "'";
    }

    @Override
    public String toString() {
        return "TransactionId: " + this.getName();
    }
}

