/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.jdp.ast;

import ch.e2e.builder.jdp.ast.Parameter;
import ch.e2e.builder.jdp.ast.XlibException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MethodDeclaration {
    private final String name;
    private final String description;
    private final String returnDescription;
    private final List<Parameter> parameters;
    private final List<XlibException> exceptions;

    private MethodDeclaration() {
        this(null, null, Collections.emptyList());
    }

    public MethodDeclaration(String name, String description, List<Parameter> parameters) {
        this.name = name;
        this.description = description;
        this.returnDescription = null;
        this.parameters = parameters;
        this.exceptions = Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public String getReturnDescription() {
        return this.returnDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<XlibException> getExceptions() {
        return this.exceptions;
    }

    public String getFullDescription() {
        return this.exceptions.isEmpty() ? this.description : this.description + this.throwsList();
    }

    private String throwsList() {
        return this.exceptions.stream().map(MethodDeclaration::toHtmlDdElement).collect(Collectors.joining("\n", "\n<dl>\n<dt>Throws:</dt>\n", "\n</dl>\n"));
    }

    private static String toHtmlDdElement(XlibException exception) {
        return String.format("<dd><code>%s</code> - %s</dd>", exception.getName(), exception.getMessage());
    }
}

