/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

class BridgeServiceCommandAction {
    private static final String HTTP_CONTENT_TYPE = "Content-Type";
    private static final String HTTP_CONTENT_LENGTH = "Content-Length";
    private static final String HTTP_THIS_CONTENT_TYPE = "text/xml; charset=utf-8";
    static final String HTTP_POST = "POST";
    static final String HTTP_GET = "GET";
    static final String PROTOCOL = "http";

    BridgeServiceCommandAction() {
    }

    InputStream configureService(String method, String protocol, String host, Integer port, String urlPath, String requestContent, Map additionalHeaders) throws IOException {
        HttpURLConnection connection = this.doRequest(method, host, port, urlPath, requestContent, additionalHeaders, protocol);
        connection.getResponseCode();
        return connection.getInputStream();
    }

    private HttpURLConnection doRequest(String method, String host, Integer port, String urlPath, String payload, Map<String, String> additionalHeaders, String protocol) throws IOException {
        StringBuilder urlString = new StringBuilder();
        urlString.append(protocol);
        urlString.append("://");
        urlString.append(host);
        urlString.append(":");
        urlString.append(port);
        if (null != urlPath && !urlPath.isEmpty()) {
            if (!urlPath.startsWith("/")) {
                urlString.append("/");
            }
            urlString.append(urlPath);
        }
        URL requestUrl = new URL(urlString.toString());
        byte[] data = new byte[]{};
        HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod(method);
        if (!method.equalsIgnoreCase(HTTP_GET) && payload != null) {
            data = payload.getBytes("UTF-8");
            connection.setDoInput(true);
            connection.setRequestProperty(HTTP_CONTENT_TYPE, HTTP_THIS_CONTENT_TYPE);
            connection.setRequestProperty(HTTP_CONTENT_LENGTH, String.valueOf(data.length));
        }
        for (Map.Entry<String, String> header : additionalHeaders.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        connection.setUseCaches(true);
        connection.setInstanceFollowRedirects(false);
        if (!method.equalsIgnoreCase(HTTP_GET)) {
            OutputStream os = connection.getOutputStream();
            os.write(data, 0, data.length);
        }
        return connection;
    }
}

