/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.xslt;

import ch.e2e.bridge.server.JavaAddOn;
import ch.e2e.bridge.server.Request;
import ch.e2e.bridge.server.RequestElement;
import ch.e2e.bridge.server.dataitem.ArrayItem;
import ch.e2e.bridge.server.dataitem.BlobItem;
import ch.e2e.bridge.server.dataitem.ItemFactory;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.SimpleItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.bridge.server.session.Session;
import ch.e2e.bridge.server.xslt.TransformerLoader;
import ch.e2e.bridge.server.xslt.XSLTExtractUtilities;
import ch.e2e.bridge.server.xslt.XSLTLogger;
import ch.e2e.bridge.server.xslt.XSLTScript;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTAddOn
extends JavaAddOn {
    private XSLTScript script;

    public XSLTAddOn(String name) {
        super(name);
    }

    @Override
    protected void initialize(String name, Request request, ArrayList<String> initializeErrors) {
        this.script = XSLTAddOn.readConfiguration(request);
    }

    @Override
    public boolean execute(RecordItem inputItem, RecordItem outputItem, Session session) throws Exception {
        session.log(5L, "JAVA", "XSLT", "XsltAddOn.execute", "Starting xslt transformation");
        boolean result = true;
        if (this.script == null) {
            result = false;
        } else {
            try {
                SimpleItem resultItem;
                StreamSource src;
                long time;
                SimpleItem input;
                StreamResult streamResult;
                Closeable resultStream;
                Transformer transformer = TransformerLoader.getInstance().borrowTransformer(this.script, session);
                boolean blobInOut = inputItem.getItem(0L) instanceof BlobItem;
                if (blobInOut) {
                    resultStream = new ByteArrayOutputStream();
                    streamResult = new StreamResult((OutputStream)resultStream);
                    input = inputItem.getBlobItem(0);
                    time = new Date().getTime();
                    src = new StreamSource(((BlobItem)input).getValueAsInputStream(InputStream.class));
                } else {
                    resultStream = new StringWriter();
                    streamResult = new StreamResult((StringWriter)resultStream);
                    input = inputItem.getStringItem(0);
                    time = new Date().getTime();
                    src = new StreamSource(new StringReader(((StringItem)input).getValueAsString()));
                }
                long time1 = new Date().getTime();
                session.log(5L, "JAVA", "XSLT", "XsltAddOn.execute", String.format("source loaded in %d ms", time1 - time));
                RecordItem parameters = inputItem.getRecordItemCreateIfNotExists(1);
                ArrayItem parameterArray = parameters.getArrayItemCreateIfNotExists(0);
                int length = parameterArray.size();
                for (int i = 0; i < length; ++i) {
                    RecordItem parameter = parameterArray.getRecordItem(i);
                    String name = parameter.getItem(0L).toString();
                    String value = parameter.getItem(1L).toString();
                    if (name.length() <= 0) continue;
                    transformer.setParameter(name, value);
                }
                session.log(5L, "JAVA", "XSLT", "XsltAddOn.execute", "transforming ...");
                time = new Date().getTime();
                transformer.transform(src, streamResult);
                time1 = new Date().getTime();
                session.log(5L, "JAVA", "XSLT", "XsltAddOn.execute", String.format("transformed in %d ms", time1 - time));
                time = time1;
                TransformerLoader.getInstance().returnTransformer(this.script, transformer);
                if (blobInOut) {
                    resultItem = ItemFactory.createBlobItem(session);
                    ((BlobItem)resultItem).setValueFromByteArray(((ByteArrayOutputStream)resultStream).toByteArray());
                } else {
                    resultItem = ItemFactory.createStringItem(session);
                    ((StringItem)resultItem).setValueFromString(resultStream.toString());
                }
                outputItem.addItem(resultItem);
                time1 = new Date().getTime();
                session.log(5L, "JAVA", "XSLT", "XsltAddOn.execute", String.format("result set in %d ms", time1 - time));
            }
            catch (FactoryConfigurationError | TransformerException e) {
                this.doErrorHandling(e, session, "0");
                result = false;
            }
        }
        return result;
    }

    private static synchronized XSLTScript readConfiguration(Request request) {
        RequestElement config = request.getAdditionalConfiguration();
        RequestElement scriptConfig = config.getRequestElement("XSLTScript");
        RequestElement processor = config.getRequestElement("XSLTProcessor");
        String factory = processor.getAttribute("factory");
        XSLTExtractUtilities.unpackXSLTArchives(processor.getRequestElements("XSLTArchive"));
        return new XSLTScript(scriptConfig.getAttribute("name"), factory);
    }

    @Override
    protected void printStackTrace(Throwable t, String code) {
        XSLTLogger.getInstance().debug(code, t);
    }
}

