/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.regtest.testsuite.Library;
import ch.e2e.builder.regtest.testsuite.LibraryChildSuite;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.test.Testable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public abstract class TestableTransferable<T extends Testable>
implements Transferable {
    public static final DataFlavor LIBRARY_CHILD_SUITE_DATA_FLAVOR = new DataFlavor(LibraryChildSuite.class, LibraryChildSuite.class.getName());
    public static final DataFlavor LIBRARY_DATA_FLAVOR = new DataFlavor(Library.class, Library.class.getName());
    public static final DataFlavor TESTCASE_DATA_FLAVOR = new DataFlavor(Testcase.class, Testcase.class.getName());
    public static final DataFlavor TESTABLE_DATA_FLAVOR = new DataFlavor(Testable.class, Testable.class.getName());
    public static final DataFlavor TESTSUITE_DATA_FLAVOR = new DataFlavor(TreeTestSuite.class, TreeTestSuite.class.getName());
    private T testData;
    private DataFlavor[] flavors;

    private TestableTransferable(T testsuite, DataFlavor flavor) {
        this.testData = testsuite;
        this.flavors = new DataFlavor[]{flavor, TESTABLE_DATA_FLAVOR};
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])this.flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor supported : this.flavors) {
            if (!supported.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public T getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this.testData;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    /* synthetic */ TestableTransferable(Testable x0, DataFlavor x1, 1 x2) {
        this(x0, x1);
    }

    public static class LibraryChildSuiteTransferable
    extends TestableTransferable<LibraryChildSuite> {
        public LibraryChildSuiteTransferable(LibraryChildSuite testsuite) {
            super((Testable)testsuite, LIBRARY_CHILD_SUITE_DATA_FLAVOR, null);
        }
    }

    public static class LibraryTransferable
    extends TestableTransferable<Library> {
        public LibraryTransferable(Library library) {
            super((Testable)library, LIBRARY_DATA_FLAVOR, null);
        }
    }

    public static class TestcaseTransferable
    extends TestableTransferable<Testcase> {
        public TestcaseTransferable(Testcase testcase) {
            super((Testable)testcase, TESTCASE_DATA_FLAVOR, null);
        }
    }

    public static class TestsuiteTransferable
    extends TestableTransferable<TreeTestSuite> {
        public TestsuiteTransferable(TreeTestSuite testsuite) {
            super((Testable)testsuite, TESTSUITE_DATA_FLAVOR, null);
        }
    }
}

