/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.ListSelectionLayout;
import ch.e2e.builder.base.gui.ListSelectionList;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.event.CompareTestActionEvent;
import ch.e2e.builder.regtest.event.CompareTestActionListener;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedEvent;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedListener;
import ch.e2e.builder.regtest.tools.TestClassFactory;
import ch.e2e.swing.model.SortedListModel;
import ch.e2e.test.E2ETask;
import ch.e2e.test.E2ETest;
import ch.e2e.test.E2ETestcase;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.TestType;
import ch.e2e.test.Testable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GeneralTestcasePreferencesPanel
extends JPanel
implements OptionInputChangedListener {
    private static LeftListCellRenderer leftListCellRenderer = new LeftListCellRenderer();
    private static RightListCellRenderer rightListCellRenderer = new RightListCellRenderer();
    private JLabel nameField;
    private JLabel testactionLabel;
    private JButton addButton;
    private JButton removeButton;
    private SortedListModel<ListElement> leftListModel;
    private ListSelectionList leftList;
    private SortedListModel<ListElement> rightListModel;
    private ListSelectionList rightList;
    private E2ETestcase testcase;
    private CompareTestActionListener compareTestActionListener;

    public GeneralTestcasePreferencesPanel(E2EBuilderModule module) {
        this.createGui(module);
    }

    @Override
    public void optionChanged(OptionInputChangedEvent event) {
        if (event.getKey().equals("key.option.test.name")) {
            this.nameField.setText(event.getValue() == null ? null : event.getValue().toString());
        }
    }

    public void setTestcase(E2ETestcase testcase, boolean readOnly) {
        leftListCellRenderer.test = testcase.getTest();
        this.testcase = testcase;
        this.nameField.setText(testcase.getName());
        this.testactionLabel.setText(testcase.getTest() == null ? "Testaction not found" : testcase.getTest().getType().toString());
        this.rightListModel.clear();
        if (testcase.getResult() != null) {
            for (ResultCompare item : testcase.getResult().getResultCompares()) {
                this.rightListModel.add((Object)new ListElement(null, item));
            }
        }
        boolean listSelectionEnabled = !readOnly && !(testcase.getTest() instanceof E2ETask);
        this.leftList.setEnabled(listSelectionEnabled);
        this.rightList.setEnabled(listSelectionEnabled);
        this.removeButton.setEnabled(listSelectionEnabled);
        this.addButton.setEnabled(listSelectionEnabled);
        if (!listSelectionEnabled) {
            this.leftList.clearSelection();
            this.rightList.clearSelection();
        }
    }

    public void persist() {
        ArrayList<ResultCompare> resultCompares = new ArrayList<ResultCompare>();
        this.testcase.setName(this.nameField.getText());
        int length = this.rightList.getModel().getSize();
        for (int i = 0; i < length; ++i) {
            resultCompares.add(((ListElement)this.rightList.getModel().getElementAt(i)).compare);
        }
        this.testcase.getResult().setResultCompares(resultCompares, (Testable)this.testcase);
    }

    public void setCompareTestActionListener(CompareTestActionListener compareTestActionListener) {
        this.compareTestActionListener = compareTestActionListener;
    }

    private void createGui(E2EBuilderModule module) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 18;
        c.fill = 2;
        JLabel nameLabel = ComponentFactory.createLabel((String)"testcase.preferences.dialog.general.label.name", (E2EBuilderModule)module);
        this.add((Component)nameLabel, c);
        this.nameField = new JLabel();
        this.nameField.setFont(this.nameField.getFont().deriveFont(1));
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)this.nameField, c);
        c.gridwidth = 1;
        c.insets = new Insets(4, 5, 2, 5);
        c.weightx = 0.0;
        JLabel testaction = ComponentFactory.createLabel((String)"testcase.preferences.dialog.general.label.testaction", (E2EBuilderModule)module);
        this.add((Component)testaction, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.testactionLabel = new JLabel();
        this.testactionLabel.setFont(this.testactionLabel.getFont().deriveFont(1));
        this.add((Component)this.testactionLabel, c);
        JLabel resultTests = ComponentFactory.createLabel((String)"testcase.preferences.dialog.general.label.resulttests", (E2EBuilderModule)module);
        c.insets = new Insets(10, 5, 2, 5);
        this.add((Component)resultTests, c);
        c.insets = new Insets(4, 5, 2, 5);
        c.fill = 1;
        c.weighty = 1.0;
        this.add((Component)this.createTestSelectionPanel(module), c);
    }

    private JPanel createTestSelectionPanel(E2EBuilderModule module) {
        JPanel result = new JPanel((LayoutManager)new ListSelectionLayout());
        result.add((Component)this.createButtons(module), "buttons");
        JPanel leftListPanel = new JPanel(new BorderLayout());
        JLabel leftLabel = new JLabel();
        leftListPanel.add((Component)leftLabel, "North");
        this.leftListModel = new SortedListModel();
        for (TestType testType : TestClassFactory.getInstance().getResultTests().values()) {
            this.leftListModel.add((Object)new ListElement(testType, null));
        }
        this.leftList = this.createList(this.leftListModel, new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GeneralTestcasePreferencesPanel.this.leftListSelectionChanged();
            }
        }, this.addButton, module);
        this.leftList.setCellRenderer((ListCellRenderer)leftListCellRenderer);
        JScrollPane scrollPane = new JScrollPane((Component)this.leftList, 20, 30);
        leftListPanel.add((Component)scrollPane, "Center");
        result.add((Component)leftListPanel, "leftList");
        JPanel rightListPanel = new JPanel(new BorderLayout());
        JLabel rightLabel = new JLabel();
        rightListPanel.add((Component)rightLabel, "North");
        this.rightListModel = new SortedListModel();
        this.rightList = this.createList(this.rightListModel, new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GeneralTestcasePreferencesPanel.this.rightListSelectionChanged();
            }
        }, this.removeButton, module);
        this.rightList.setCellRenderer((ListCellRenderer)rightListCellRenderer);
        scrollPane = new JScrollPane((Component)this.rightList, 20, 30);
        rightListPanel.add((Component)scrollPane, "Center");
        result.add((Component)rightListPanel, "rightList");
        return result;
    }

    private void rightListSelectionChanged() {
        this.leftList.clearSelection();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(this.rightList.getSelectedValue() != null);
    }

    private void leftListSelectionChanged() {
        this.rightList.clearSelection();
        this.addButton.setEnabled(this.leftList.getSelectedValue() != null);
        this.removeButton.setEnabled(false);
    }

    private ListSelectionList createList(SortedListModel listModel, ListSelectionListener selectionListener, JButton action, E2EBuilderModule module) {
        ListSelectionList list = new ListSelectionList((ListModel)listModel, action, module);
        list.addListSelectionListener(selectionListener);
        return list;
    }

    private JPanel createButtons(E2EBuilderModule module) {
        this.addButton = ComponentFactory.createButton((String)"-->", (E2EBuilderModule)module);
        this.removeButton = ComponentFactory.createButton((String)"<--", (E2EBuilderModule)module);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(15, 15, 15, 15);
        buttonPanel.add((Component)this.addButton, c);
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTestcasePreferencesPanel.this.doAddAction();
            }
        });
        c.insets = new Insets(0, 15, 15, 15);
        buttonPanel.add((Component)this.removeButton, c);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTestcasePreferencesPanel.this.doRemoveAction();
            }
        });
        return buttonPanel;
    }

    private void doRemoveAction() {
        ListElement compareElement = (ListElement)this.rightList.getSelectedValue();
        this.rightListModel.remove((Object)compareElement);
        if (this.compareTestActionListener != null) {
            this.compareTestActionListener.compareTestRemoved(new CompareTestActionEvent(this, compareElement.compare));
        }
        this.leftListModel.add((Object)compareElement);
    }

    private void doAddAction() {
        try {
            ResultCompare compare;
            ListElement value = (ListElement)this.leftList.getSelectedValue();
            if (value.compare == null) {
                compare = (ResultCompare)value.type.newInstance();
            } else {
                compare = value.compare;
                this.leftListModel.remove((Object)value);
            }
            if (this.compareTestActionListener != null) {
                this.compareTestActionListener.compareTestAdded(new CompareTestActionEvent(this, compare));
            }
            this.rightListModel.add((Object)new ListElement(null, compare));
            this.testcase.getTest().prepareCompareType(compare);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class RightListCellRenderer
    extends DefaultListCellRenderer {
        private E2ETest test;

        private RightListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ListElement element = (ListElement)value;
            result.setIcon(element.compare.getType().getIcon());
            return result;
        }
    }

    private static class LeftListCellRenderer
    extends DefaultListCellRenderer {
        private E2ETest test;

        private LeftListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ListElement element = (ListElement)value;
            JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, element.toTypeString(), index, isSelected, cellHasFocus);
            if (element.type == null) {
                result.setIcon(element.compare.getType().getIcon());
            } else {
                if (this.test.isRecommendedCompareType(element.type)) {
                    result.setFont(result.getFont().deriveFont(1));
                } else {
                    result.setFont(result.getFont().deriveFont(0));
                }
                result.setIcon(element.type.getIcon());
            }
            return result;
        }
    }

    private class ListElement {
        private TestType type;
        private ResultCompare compare;

        private ListElement(TestType type, ResultCompare compare) {
            this.type = type;
            this.compare = compare;
        }

        public String toString() {
            return this.compare == null ? this.type.getName() : this.compare.getName();
        }

        public String toTypeString() {
            return this.type == null ? this.compare.getType().toString() : this.type.toString();
        }
    }
}

