/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.test.Testable;
import ch.e2e.util.StringTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import junit.framework.TestResult;

public class CounterPanel
extends JPanel {
    private JTextField numberOfErrors;
    private JTextField elapsedTime;
    private JTextField numberOfRuns;
    private long startTime = 0L;
    private int errorCount;
    private int failureCount;
    private int total;
    private TestResult testResult;
    private JLabel errors;

    public CounterPanel(E2EBuilderModule module) {
        super(new GridBagLayout());
        this.createGui(module);
        this.addEventHandler();
    }

    private void addEventHandler() {
    }

    private void createGui(E2EBuilderModule module) {
        this.numberOfErrors = this.createOutputField(5);
        this.elapsedTime = this.createOutputField(5);
        this.numberOfRuns = this.createOutputField(9);
        JLabel runs = ComponentFactory.createLabel((String)"counter.panel.label.runs", (E2EBuilderModule)module);
        runs.setHorizontalAlignment(0);
        this.addToGrid(runs, 0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0));
        this.addToGrid(this.numberOfRuns, 1, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
        this.errors = ComponentFactory.createLabel((String)"counter.panel.label.errors", (E2EBuilderModule)module);
        this.errors.setHorizontalAlignment(2);
        this.addToGrid(this.errors, 2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0));
        this.addToGrid(this.numberOfErrors, 3, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
        JLabel failures = ComponentFactory.createLabel((String)"counter.panel.label.elapsed.time", (E2EBuilderModule)module);
        failures.setHorizontalAlignment(2);
        this.addToGrid(failures, 4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0));
        this.addToGrid(this.elapsedTime, 5, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
    }

    private JTextField createOutputField(int width) {
        JTextField field = new JTextField("0", width);
        field.setMinimumSize(field.getPreferredSize());
        field.setMaximumSize(field.getPreferredSize());
        field.setHorizontalAlignment(2);
        field.setEditable(false);
        field.setBorder(BorderFactory.createEmptyBorder());
        return field;
    }

    public void addToGrid(Component comp, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = gridwidth;
        constraints.gridheight = gridheight;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.anchor = anchor;
        constraints.fill = fill;
        constraints.insets = insets;
        this.add(comp, constraints);
    }

    public void reset() {
        this.numberOfErrors.setText("0");
        this.elapsedTime.setText("0s");
        this.numberOfRuns.setText("0");
        this.total = 0;
        this.errorCount = 0;
        this.failureCount = 0;
        this.setErrorColor();
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void testUnitStarting() {
        this.setRunValue(0);
        this.startTime = new Date().getTime();
        this.elapsedTime.setText("0s");
    }

    public void testUnitFinished() {
        this.setElapsedTime();
    }

    public void setRunValue(int value) {
        this.numberOfRuns.setText(Integer.toString(value) + "/" + this.total);
        this.setElapsedTime();
    }

    public void setErrorValue(int value) {
        this.errorCount = value;
        this.setLabelValue(this.numberOfErrors, this.errorCount + this.failureCount);
        this.setErrorColor();
    }

    private void setErrorColor() {
        this.numberOfErrors.setForeground(this.errorCount + this.failureCount == 0 ? Color.BLACK : Color.RED);
        this.errors.setForeground(this.errorCount + this.failureCount == 0 ? Color.BLACK : Color.RED);
    }

    public void setFailureValue(int value) {
        this.failureCount = value;
        this.setLabelValue(this.numberOfErrors, this.errorCount + this.failureCount);
        this.setErrorColor();
    }

    private void setLabelValue(JTextField label, int value) {
        label.setText(Integer.toString(value));
    }

    public int testSelected(List<Testable> tests) {
        this.reset();
        this.total = this.countTotal(tests);
        this.numberOfRuns.setText("0/" + this.total);
        return this.total;
    }

    private int countTotal(List<Testable> tests) {
        int total = 0;
        for (Testable test : tests) {
            total += test.countTestCases();
        }
        return total;
    }

    private void setElapsedTime() {
        long time = (new Date().getTime() - this.startTime) / 1000L;
        int minutes = (int)time / 60;
        int seconds = (int)time % 60;
        String secondsStr = StringTools.prependZeros((String)String.valueOf(seconds), (int)2) + "s";
        this.elapsedTime.setText(minutes == 0 ? secondsStr : String.valueOf(minutes) + "m " + secondsStr);
    }
}

