/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui;

import ch.e2e.builder.analyzer.Logging;
import ch.e2e.builder.analyzer.gui.TraceView;
import ch.e2e.builder.analyzer.gui.TransactionLogView;
import ch.e2e.builder.analyzer.model.Trace;
import ch.e2e.builder.analyzer.model.TransactionLogObject;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.gui.testcase.MainPanelView;
import ch.e2e.builder.trace.testcase.LogFile;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.event.EventExecutionVetoException;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class MainPanel
extends JPanel
implements ProjectListener,
Logging {
    private final E2ETraceModule module;
    private MainPanelView actualView;
    private MainPanelView overview;
    private TraceView traceView;
    private TransactionLogView transactionLogsView;

    public MainPanel(E2ETraceModule module) {
        super(new CardLayout());
        this.module = module;
        this.createGui();
    }

    public Object getPrintableObject() {
        return this.actualView == null ? null : this.actualView.getPrintableObject();
    }

    public void pathChanged(TreePath path) {
        if (path != null) {
            Object root = null;
            Object object = path.getLastPathComponent();
            if (object instanceof TransactionLogObject) {
                this.setActualView(this.transactionLogsView);
                root = object;
            } else if (object instanceof Testcase) {
                this.setActualView(this.overview);
                root = object;
            } else if (object instanceof LogFile) {
                TestcaseContainer testcaseContainer = ((LogFile)object).getParent();
                if (testcaseContainer instanceof Trace) {
                    this.setActualView((MainPanelView)this.traceView);
                }
                root = object;
            } else if (object instanceof UmlObject) {
                this.setActualView((MainPanelView)this.traceView);
                root = path;
            }
            if (this.actualView != null) {
                this.actualView.setRoot(root);
            }
        } else {
            if (this.actualView != null) {
                this.actualView.setRoot(null);
            }
            this.setActualView(this.overview);
        }
    }

    @Override
    public CardLayout getLayout() {
        return (CardLayout)super.getLayout();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.overview.setEnabled(enabled);
        this.traceView.setEnabled(enabled);
        this.transactionLogsView.setEnabled(enabled);
    }

    public void clearSelection() {
        this.traceView.setRoot(null);
        this.transactionLogsView.setRoot(null);
        this.actualView = null;
    }

    private void setActualView(MainPanelView view) {
        this.getLayout().show(this, view.getName());
        this.actualView = view;
        this.module.setPrintEnabled(this.actualView.getPrintableObject() != null);
    }

    private void createGui() {
        this.overview = new MainPanelView(){

            public void refresh() {
            }

            public Object getRoot() {
                return null;
            }

            public void setRoot(Object root) {
            }

            public Object getPrintableObject() {
                return null;
            }
        };
        this.overview.setName("overview");
        this.add((Component)this.overview, this.overview.getName());
        this.traceView = new TraceView(this.module);
        this.traceView.setName("traces");
        this.add((Component)((Object)this.traceView), this.traceView.getName());
        this.transactionLogsView = new TransactionLogView((E2EBuilderModule)this.module);
        this.transactionLogsView.setName("transactionLogs");
        this.add((Component)((Object)this.transactionLogsView), this.transactionLogsView.getName());
    }

    public void doBeforeChanging(ProjectEvent event) throws EventExecutionVetoException {
    }

    public void projectSettingsChange(ProjectEvent event) {
    }

    public void doBeforeProjectOpen(ProjectEvent event) {
    }

    public void doAfterProjectOpen(ProjectEvent event) {
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void projectOpened(ProjectEvent event) {
    }
}

