/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.logging;

import ch.e2e.io.SystemErrRedirector;
import ch.e2e.io.SystemOutRedirector;
import ch.e2e.logging.LoggingCanvas;
import ch.e2e.logging.LoggingFrame;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class JavaConsole
extends JFrame
implements LoggingFrame {
    private static JavaConsole console;
    private LoggingCanvas loggingCanvas;
    private Label memoryLabel;
    private Timer memoryTimer;

    public JavaConsole() {
        super("Java Console");
        this.setBounds(20, 20, 400, 600);
        this.getContentPane().add(this.createSouthPanel(), "South");
        this.addKeyBindings();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                boolean dummy = false;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                boolean dummy = false;
            }

            @Override
            public void windowClosed(WindowEvent e) {
                boolean dummy = false;
            }

            @Override
            public void windowIconified(WindowEvent e) {
                boolean dummy = false;
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                boolean dummy = false;
            }

            @Override
            public void windowActivated(WindowEvent e) {
                boolean dummy = false;
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                boolean dummy = false;
            }
        });
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                boolean dummy = false;
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                boolean dummy = false;
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                boolean dummy = false;
            }

            @Override
            public void componentShown(ComponentEvent e) {
                JavaConsole.this.memoryTimer = new Timer();
                JavaConsole.this.memoryTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        JavaConsole.this.memoryLabel.setText("Memory usage: " + Runtime.getRuntime().totalMemory() / 1000000L + " / " + Runtime.getRuntime().maxMemory() / 1000000L);
                    }
                }, 0L, 2000L);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                if (JavaConsole.this.memoryTimer != null) {
                    JavaConsole.this.memoryTimer.cancel();
                    JavaConsole.this.memoryTimer.purge();
                    JavaConsole.this.memoryTimer = null;
                }
            }
        });
        console = this;
    }

    public static JavaConsole getInstance() {
        if (console == null) {
            console = new JavaConsole();
            console.initialize(new LoggingCanvas());
            console.setSystemErrEnabled(true);
            console.setSystemOutEnabled(true);
        }
        return console;
    }

    @Override
    public void initialize(LoggingCanvas loggingCanvas) {
        this.loggingCanvas = loggingCanvas;
        this.loggingCanvas.setAutoscrolls(true);
        JScrollPane scrollPane = new JScrollPane(loggingCanvas, 20, 30);
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    public static void revertVisibility() {
        if (console != null) {
            console.setVisible(!console.isVisible());
        }
    }

    @Override
    public void open() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                console.setVisible(true);
            }
        });
    }

    @Override
    public void setSystemOutEnabled(boolean enabled) {
        if (enabled) {
            SystemOutRedirector.getInstance().setEnabled(true);
            SystemOutRedirector.getInstance().setOriginalStreamEnabled(true);
        }
    }

    @Override
    public void setSystemErrEnabled(boolean enabled) {
        if (enabled) {
            SystemErrRedirector.getInstance().setEnabled(true);
            SystemErrRedirector.getInstance().setOriginalStreamEnabled(true);
        }
    }

    private Component createSouthPanel() {
        Panel south = new Panel(new GridLayout(2, 1));
        south.add(this.getMemoryMonitor());
        south.add(this.getButtonPanel());
        return south;
    }

    private Panel getButtonPanel() {
        Panel p = new Panel();
        Button b = new Button("Clear");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsole.this.loggingCanvas.clear();
            }
        });
        p.add(b);
        return p;
    }

    private Component getMemoryMonitor() {
        this.memoryLabel = new Label("Memory usage: " + Runtime.getRuntime().totalMemory() / 1000L + " / " + Runtime.getRuntime().maxMemory() / 1000L);
        return this.memoryLabel;
    }

    private void addKeyBindings() {
        InputMap inputMap = this.getRootPane().getInputMap(1);
        ActionMap actionMap = this.getRootPane().getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("control F"), "ch.e2e.logging.find");
        actionMap.put("ch.e2e.logging.find", new AbstractAction("ch.e2e.logging.find"){

            @Override
            public void actionPerformed(ActionEvent event) {
                String textToFind = new FindDialog().getTextToFind(null);
                if (textToFind != null && textToFind.length() > 0) {
                    JavaConsole.this.loggingCanvas.requestFocus();
                    JavaConsole.this.loggingCanvas.find(textToFind);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("F3"), "find.again");
        actionMap.put("find.again", new AbstractAction("find.again"){

            @Override
            public void actionPerformed(ActionEvent event) {
                JavaConsole.this.loggingCanvas.findAgain();
            }
        });
    }

    private class FindDialog
    extends JDialog {
        private JTextField textToFind;
        private String result;

        private FindDialog() {
            super(JavaConsole.this, "Find ...", true);
            this.createGui();
        }

        private String getTextToFind(String selection) {
            this.result = null;
            if (selection != null) {
                this.textToFind.setText(selection);
                this.textToFind.setSelectionStart(0);
                this.textToFind.setSelectionEnd(selection.length());
            } else {
                this.textToFind.setText("");
                this.textToFind.setSelectionStart(0);
                this.textToFind.setSelectionEnd(0);
            }
            this.pack();
            this.centerOnOwner();
            this.setVisible(true);
            return this.result;
        }

        private void createGui() {
            this.textToFind = new JTextField(40);
            this.textToFind.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindDialog.this.result = FindDialog.this.textToFind.getText();
                    FindDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add(this.textToFind);
            JPanel buttonPanel = new JPanel();
            JButton ok = new JButton("Ok");
            buttonPanel.add(ok);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindDialog.this.result = FindDialog.this.textToFind.getText();
                    FindDialog.this.setVisible(false);
                }
            });
            JButton cancel = new JButton("Cancel");
            buttonPanel.add(cancel);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindDialog.this.result = null;
                    FindDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)buttonPanel, "South");
        }

        private void centerOnOwner() {
            int yPos;
            Rectangle bounds = JavaConsole.this.getBounds();
            Dimension dialogSize = this.getSize();
            int xPos = bounds.x + (bounds.width - dialogSize.width) / 2;
            if (xPos < 0) {
                xPos = 0;
            }
            if ((yPos = bounds.y + (bounds.height - dialogSize.height) / 2) < 0) {
                yPos = 0;
            }
            this.setBounds(xPos, yPos, dialogSize.width, dialogSize.height);
        }
    }
}

