/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.event;

import ch.e2e.event.EventExecuterList;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;

public class DefaultHandler {
    private Hashtable handlerTable = new Hashtable();

    protected DefaultHandler() {
    }

    public void putHandler(Class eventObject, Class eventExecuter) {
        ArrayList<Class> executer = (ArrayList<Class>)this.handlerTable.get(eventObject.getName());
        if (executer == null) {
            executer = new ArrayList<Class>();
        }
        executer.add(eventExecuter);
        this.handlerTable.put(eventObject.getName(), executer);
    }

    public void checkDefaultExecuter(EventObject event, EventExecuterList controllerList) {
        ArrayList executer = (ArrayList)this.handlerTable.get(event.getClass().getName());
        if (executer != null) {
            this.handlerTable.remove(event.getClass().getName());
            this.createDefaultExecuter(executer, controllerList);
            this.removeListeners(executer);
        }
    }

    private void createDefaultExecuter(ArrayList executer, EventExecuterList controllerList) {
        int length = executer.size();
        for (int i = 0; i < length; ++i) {
            Class executerClass = (Class)executer.get(i);
            controllerList.addDefaultExecuterInstance(executerClass);
        }
    }

    private void removeListeners(ArrayList executer) {
        for (Class listener : executer) {
            ArrayList<String> keysToRemove = new ArrayList<String>();
            for (String key : this.handlerTable.keySet()) {
                ArrayList defaultListeners = (ArrayList)this.handlerTable.get(key);
                if (!defaultListeners.contains(listener)) continue;
                defaultListeners.remove(listener);
                if (defaultListeners.size() != 0) continue;
                keysToRemove.add(key);
            }
            int length = keysToRemove.size();
            for (int i = 0; i < length; ++i) {
                Object key = keysToRemove.get(i);
                this.handlerTable.remove(key);
            }
        }
    }
}

