/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.base;

import ch.e2e.builder.base.tools.ClientFactory;
import ch.e2e.builder.compiler.assetRepository.AssetRepositoryService;
import ch.e2e.builder.compiler.build.tasks.source.ProjectFileSource;
import ch.e2e.builder.compiler.build.tasks.source.SimpleSourceFactory;
import ch.e2e.builder.compiler.build.tasks.source.SourceManagerFactory;
import ch.e2e.builder.compiler.serviceRepository.ServiceRepositoryService;
import ch.e2e.builder.compiler.utils.EnvUtils;
import ch.e2e.builder.compiler.utils.TokenManager;
import com.scheer.pas.module.Export;
import com.scheer.pas.module.Module;
import com.scheer.pas.module.RegisterContext;
import javax.ws.rs.client.Client;

public class CompilerBaseModule
extends Module {
    private static final boolean USE_TRUSTING_CLIENT = EnvUtils.get("USE_TRUSTING_CLIENT", false);
    private static final int XUML_COMPILER_SERVICE_REST_TIMEOUT_SEC = EnvUtils.get("XUML_COMPILER_SERVICE_REST_TIMEOUT_SEC", 900);
    public static final String KEYCLOAK_URI = EnvUtils.get("KEYCLOAK_URI", "http://pas-keycloak:8080/pas/keycloak");
    private static final String KEYCLOAK_REALM = EnvUtils.get("KEYCLOAK_REALM", "PAS");
    private static final String KEYCLOAK_COMPILER_SERVICE_CLIENT_ID = EnvUtils.get("KEYCLOAK_XUML_COMPILER_SERVICE_CLIENT_ID", "xuml-compiler-service");
    private static final String KEYCLOAK_COMPILER_SERVICE_CLIENT_SECRET = EnvUtils.get("KEYCLOAK_XUML_COMPILER_SERVICE_CLIENT_SECRET", "password");
    @Export
    SourceManagerFactory sourceManagerFactory = new SourceManagerFactory();
    @Export
    Client client = ClientFactory.createClient((boolean)USE_TRUSTING_CLIENT, (int)XUML_COMPILER_SERVICE_REST_TIMEOUT_SEC);
    @Export
    private final TokenManager tokenManager = TokenManager.newBuilder(KEYCLOAK_URI, KEYCLOAK_REALM).grantType(TokenManager.GrantType.CLIENT_CREDENTIALS).clientId(KEYCLOAK_COMPILER_SERVICE_CLIENT_ID).clientSecret(KEYCLOAK_COMPILER_SERVICE_CLIENT_SECRET).restClient(this.client).build();
    @Export
    ServiceRepositoryService serviceRepositoryService = new ServiceRepositoryService(this.client, this.tokenManager);
    @Export
    AssetRepositoryService assetRepositoryService = new AssetRepositoryService(this.client, this.tokenManager);

    @Override
    public void register(RegisterContext registerContext) throws Exception {
        this.sourceManagerFactory.addSourceFactory(new SimpleSourceFactory(id -> true, ProjectFileSource.class));
    }
}

