/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.base;

import ch.e2e.builder.compiler.build.tasks.model.CopyFromTemplateTask;
import ch.e2e.builder.compiler.build.tasks.model.CopyFromTemplateXmlTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.Json2XmlTask;
import ch.e2e.builder.compiler.build.tasks.rest.RestTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSourceFile;
import ch.e2e.builder.compiler.build.tasks.source.SimpleSourceFactory;
import ch.e2e.builder.compiler.build.tasks.source.SimpleTaskFactory;
import ch.e2e.builder.compiler.build.tasks.source.TaskFactory;
import com.scheer.pas.compiler.angular.base.DistRepositoryItemType;
import com.scheer.pas.compiler.angular.base.document.json.XumlApp;
import com.scheer.pas.compiler.angular.base.libraries.TgzLibraryItemType;
import com.scheer.pas.compiler.angular.base.tasks.AngularCopyVersionTask;
import com.scheer.pas.compiler.angular.base.tasks.AngularDistZipTask;
import com.scheer.pas.compiler.angular.base.tasks.GitignoreFileTask;
import com.scheer.pas.compiler.angular.base.tasks.dev.AngularTestArtifactType;
import com.scheer.pas.compiler.angular.base.tasks.dev.DevAngularSourceTask;
import com.scheer.pas.compiler.angular.base.tasks.library.AngularLibraryDescriptorContentTask;
import com.scheer.pas.compiler.angular.base.tasks.typescript.LibraryTypescriptImportsTask;
import com.scheer.pas.compiler.angular.core.AngularTaskFactory;
import com.scheer.pas.compiler.angular.core.constants.Files;
import com.scheer.pas.compiler.core.CompilerModule;
import com.scheer.pas.compiler.dev.api.artifacts.TestArtifactTypeService;
import com.scheer.pas.compiler.xuml.api.tasks.libraries.LibraryItemTypeService;
import com.scheer.pas.compiler.xuml.api.tasks.repositories.RepositoryItemTypeService;
import com.scheer.pas.module.Import;
import com.scheer.pas.module.RegisterContext;
import javax.ws.rs.client.Client;

public class AngularCompilerBaseModule
extends CompilerModule {
    @Import
    LibraryItemTypeService libraryItemTypeService;
    @Import
    RepositoryItemTypeService repositoryItemTypeService;
    @Import
    TestArtifactTypeService testArtifactTypeService;
    @Import
    Client client;

    @Override
    public void register(RegisterContext registerContext) throws Exception {
        this.registerSources();
        this.registerTasks();
        if (this.libraryItemTypeService != null) {
            this.libraryItemTypeService.add(new TgzLibraryItemType());
        }
        if (this.repositoryItemTypeService != null) {
            this.repositoryItemTypeService.add(new DistRepositoryItemType());
        }
        if (this.testArtifactTypeService != null) {
            this.testArtifactTypeService.add(new AngularTestArtifactType());
        }
    }

    private void registerSources() {
        this.sourceManagerFactory.addSourceFactory(new SimpleSourceFactory(XumlApp::select, JsonDocumentSourceFile.class, (Double)3.0));
    }

    private void registerTasks() {
        this.sourceManagerFactory.addTaskFactory(new SimpleTaskFactory(AngularLibraryDescriptorContentTask.class, 3.0));
        this.sourceManagerFactory.addTaskFactory(new SimpleTaskFactory(id -> id.equals(Files.angular__appDist_artifact_xml), CopyFromTemplateXmlTask.class, (Double)3.0));
        this.sourceManagerFactory.addTaskFactory(new Json2XmlTask.Factory(XumlApp.class, 3.0));
        this.sourceManagerFactory.addTaskFactory(new SimpleTaskFactory(XumlApp::selectDefault, CopyFromTemplateTask.class, (Double)3.0));
        this.sourceManagerFactory.addTaskFactory(new SimpleTaskFactory(AngularDistZipTask.class, 3.1));
        this.sourceManagerFactory.addTaskFactory(new SimpleTaskFactory(AngularCopyVersionTask.class, 3.0));
        this.sourceManagerFactory.addTaskFactory(new SimpleTaskFactory(LibraryTypescriptImportsTask.class, 3.0));
        this.addAngularTaskFactory(new SimpleTaskFactory(GitignoreFileTask.class, 3.0));
        this.sourceManagerFactory.addTaskFactory(new RestTask.Factory(DevAngularSourceTask.class, this.client, (Double)3.0));
    }

    protected void addAngularTaskFactory(TaskFactory factory) {
        this.sourceManagerFactory.addTaskFactory(new AngularTaskFactory("([^/]*)", factory));
    }
}

