/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.DependencyClient;
import ch.e2e.builder.compiler.uml.DependencyEvent;
import ch.e2e.builder.compiler.uml.DependencyListener;
import ch.e2e.builder.compiler.uml.DependencySupplier;
import ch.e2e.builder.compiler.uml.DependencySupplierDefinition;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.NoSuchPropertyException;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class DependencyClientList
extends DeploymentElement
implements DependencyListener {
    private int index = -1;
    private ArrayList<BridgeStereotype> clientTypes;
    private TreeSet<DependencyClient> dependencyClients = new TreeSet<DependencyClient>(new DependencyTypeComparator());
    private HashMap<BridgeStereotype, ArrayList<DependencySupplier>> dependencySuppliers;
    private ArrayList<UmlElement> allSuppliers;
    private ArrayList<DeploymentElement> aliases;

    public DependencyClientList(Helpers helpers) {
        super("DependencyClients", new Comment("", helpers), helpers);
        this.clientTypes = new ArrayList();
        this.dependencySuppliers = new HashMap();
        this.allSuppliers = new ArrayList();
        this.aliases = new ArrayList();
    }

    public ArrayList<UmlElement> getChildren() {
        return this.allSuppliers;
    }

    public void addDependencyClient(DeploymentElement client) {
        ArrayList<DependencySupplier> suppliers;
        if (!this.clientTypes.contains(client.getStereotype())) {
            this.clientTypes.add(client.getStereotype());
        }
        if ((suppliers = this.dependencySuppliers.get(client.getStereotype())) == null) {
            suppliers = new ArrayList();
            this.dependencySuppliers.put(client.getStereotype(), suppliers);
            ArrayList<UmlElement> addedSuppliers = new ArrayList<UmlElement>();
            this.findExistingSuppliers(client.getStereotype().getCustomization().getDependencySuppliers(), suppliers, addedSuppliers);
        }
        DependencyClient dependencyClient = new DependencyClient(client, suppliers, this.getHelpers());
        this.dependencyClients.add(dependencyClient);
        dependencyClient.setDependencyListener(this);
        client.getBridgeDependencies().setSelectable(suppliers.size() > 0);
    }

    public void addDependencySupplier(DeploymentElement supplier) {
        if (!this.allSuppliers.contains(supplier)) {
            this.allSuppliers.add(supplier);
        }
        for (BridgeStereotype stereotype : this.clientTypes) {
            ArrayList<DependencySupplierDefinition> dependencySuppliers = stereotype.getCustomization().getDependencySuppliers();
            for (DependencySupplierDefinition definition : dependencySuppliers) {
                if (!definition.getSupplier().equals(supplier.getStereotype())) continue;
                DependencySupplier dependencySupplier = new DependencySupplier(supplier);
                if (this.dependencySuppliers.get(stereotype).contains(dependencySupplier)) continue;
                this.dependencySuppliers.get(stereotype).add(dependencySupplier);
                for (DependencyClient client : this.dependencyClients) {
                    if (!client.getStereotype().equals(stereotype)) continue;
                    client.getBridgeDependencies().setSelectable(true);
                }
            }
            for (UmlElement element : supplier.getChildren()) {
                this.addDependencySupplier((DeploymentElement)element);
            }
        }
    }

    public void removeDependencySupplier(DeploymentElement supplier) {
        for (BridgeStereotype stereotype : this.clientTypes) {
            ArrayList<DependencySupplierDefinition> suppliers = stereotype.getCustomization().getDependencySuppliers();
            for (DependencySupplierDefinition definition : suppliers) {
                if (!definition.getSupplier().equals(supplier.getStereotype())) continue;
                DependencySupplier dependencySupplier = new DependencySupplier(supplier);
                this.dependencySuppliers.get(stereotype).remove(dependencySupplier);
                for (DependencyClient client : this.dependencyClients) {
                    if (!client.getStereotype().equals(stereotype)) continue;
                    client.getBridgeDependencies().setSelectable(this.dependencySuppliers.get(stereotype).size() > 0);
                }
            }
        }
    }

    public boolean removeDependencyClient(DeploymentElement client) {
        boolean result = this.dependencyClients.remove(this.findDependencyClient(client));
        boolean removeClientType = true;
        Iterator<DependencyClient> elements = this.dependencyClients.iterator();
        while (elements.hasNext() && removeClientType) {
            removeClientType = !client.getStereotype().equals(elements.next().getClient().getStereotype());
        }
        if (removeClientType) {
            this.clientTypes.remove(client.getStereotype());
        }
        if (!this.clientTypes.contains(client.getStereotype())) {
            this.dependencySuppliers.get(client.getStereotype()).clear();
            this.dependencySuppliers.remove(client.getStereotype());
        }
        return result;
    }

    public DependencyClient findDependencyClient(DeploymentElement client) {
        DependencyClient result = null;
        Iterator<DependencyClient> clients = this.dependencyClients.iterator();
        while (clients.hasNext() && result == null) {
            DependencyClient dependencyClient = clients.next();
            if (!dependencyClient.getClient().equals(client)) continue;
            result = dependencyClient;
        }
        return result;
    }

    public ArrayList<BridgeStereotype> getClientTypes() {
        return this.clientTypes;
    }

    @Override
    public void dependencyAdded(DependencyEvent event) {
        try {
            this.aliases.add((DeploymentElement)event.getDependency().getProperty("alias").getValue());
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
    }

    @Override
    public void dependencyRemoved(DependencyEvent event) {
        try {
            this.aliases.remove(event.getDependency().getProperty("alias").getValue());
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
    }

    public ArrayList<DeploymentElement> getAliases() {
        return this.aliases;
    }

    public void next() {
        int lastIndex = this.index;
        int index = -1;
        int i = -1;
        Iterator<DependencyClient> clients = this.dependencyClients.iterator();
        while (clients.hasNext() && index == -1) {
            DependencyClient client = clients.next();
            index = client.hasRequiredDependency() ? ++i : -1;
        }
        if (index == -1) {
            ++this.index;
            if (this.index == this.dependencyClients.size()) {
                this.index = 0;
            }
            boolean firstWrap = true;
            boolean wrapped = false;
            while (this.dependencyClients.size() > this.index && firstWrap) {
                DependencyClient client = this.getDependencyClient();
                if (client.getSuppliers().size() > 0) {
                    ArrayList<DependencySupplier> suppliers = this.dependencySuppliers.get(client.getStereotype());
                    if (suppliers.size() != 0) break;
                    ++this.index;
                } else {
                    ++this.index;
                }
                if (this.index != this.dependencyClients.size()) continue;
                if (wrapped) {
                    firstWrap = false;
                    continue;
                }
                this.index = 0;
                wrapped = true;
            }
        } else {
            this.index = index;
        }
        if (this.index != -1 && (this.dependencySuppliers.get(this.getDependencyClient().getStereotype()).size() == 0 || lastIndex == this.index && this.areAllSuppliersConnected())) {
            this.index = -1;
        }
    }

    public TreeSet<DependencyClient> getDependencyClients() {
        return this.dependencyClients;
    }

    public ArrayList<DependencyClient> getUseableClients() {
        ArrayList<DependencyClient> result = new ArrayList<DependencyClient>();
        for (DependencyClient client : this.dependencyClients) {
            if (client.getSuppliers().size() <= 0) continue;
            result.add(client);
        }
        return result;
    }

    public DependencyClient getDependencyClient() {
        DependencyClient result = null;
        Iterator<DependencyClient> elements = this.dependencyClients.iterator();
        for (int i = -1; elements.hasNext() && i < this.index; ++i) {
            result = elements.next();
        }
        return result;
    }

    public void setDependencyClient(DependencyClient element) {
        int i = -1;
        for (DependencyClient dependencyClient : this.dependencyClients) {
            ++i;
            if (!dependencyClient.equals(element)) continue;
            this.index = i;
        }
    }

    public void reset() {
        this.index = -1;
    }

    public boolean isConnected(DeploymentElement supplier) {
        boolean connected = false;
        Iterator<DependencyClient> elements = this.dependencyClients.iterator();
        while (elements.hasNext() && !connected) {
            DependencyClient client = elements.next();
            int length = client.getClient().getBridgeDependencies().size();
            for (int i = 0; i < length && !connected; ++i) {
                connected = client.getClient().getBridgeDependencies().get(i).getSupplier().equals(supplier);
            }
        }
        return connected;
    }

    public boolean areAllSuppliersConnected() {
        return this.areAllSuppliersConnected(this.getAllDependencySuppliers());
    }

    public boolean areAllSuppliersConnected(ArrayList<DependencySupplier> useableSuppliers) {
        boolean result = true;
        ArrayList<DependencySupplier> suppliers = this.getAllDependencySuppliers();
        int length = suppliers.size();
        for (int i = 0; i < length && result; ++i) {
            DependencySupplier supplier = suppliers.get(i);
            result = !useableSuppliers.contains(supplier) || this.isConnected(supplier.getSupplierElement());
        }
        return result;
    }

    public boolean isOneSupplierConnected() {
        boolean result = false;
        ArrayList<DependencySupplier> suppliers = this.getAllDependencySuppliers();
        int length = suppliers.size();
        for (int i = 0; i < length && !result; ++i) {
            DependencySupplier supplier = suppliers.get(i);
            result = this.isConnected(supplier.getSupplierElement());
        }
        return result;
    }

    private ArrayList<DependencySupplier> getAllDependencySuppliers() {
        ArrayList<DependencySupplier> result = new ArrayList<DependencySupplier>();
        for (ArrayList<DependencySupplier> suppliers : this.dependencySuppliers.values()) {
            result.addAll(suppliers);
        }
        return result;
    }

    private static class DependencyTypeComparator
    implements Comparator<DependencyClient> {
        private DependencyTypeComparator() {
        }

        @Override
        public int compare(DependencyClient element1, DependencyClient element2) {
            int result = 0;
            if (element1 != null && element2 != null && element1.getClient() != null && element2.getClient() != null && element1.getClient().getStereotype() != null && element2.getClient().getStereotype() != null && (result = element1.getClient().getStereotype().getName().compareToIgnoreCase(element2.getClient().getStereotype().getName())) == 0) {
                result = element1.getClient().getName().compareToIgnoreCase(element2.getClient().getName());
            }
            return result;
        }
    }
}

