/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.idoc;

import ch.e2e.builder.compiler.document.importer.idoc.Attribute;
import ch.e2e.builder.compiler.document.importer.idoc.Field;
import ch.e2e.builder.compiler.document.importer.idoc.IDocContainerObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Segment
extends IDocContainerObject {
    public Segment(Element element) {
        super(element);
        this.addTaggedValues();
    }

    @Override
    public String getStereotype() {
        return IDocContainerObject.getSegmentVersion();
    }

    @Override
    public String getType() {
        return this.getAttribute("segmenttype");
    }

    private void buildFields(Node fieldNode) {
        NodeList children = fieldNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equalsIgnoreCase("field")) continue;
            Field field = new Field(child);
            field.setSegmentName(this.getName());
            this.add(field);
        }
    }

    public String toString() {
        return "Segment " + this.getName() + " (" + this.getAttributeList() + ")";
    }

    @Override
    protected void readChildren(NodeList children) {
        Attribute attribute = new Attribute("SEGMENT");
        this.add(attribute);
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("fields")) {
                this.buildFields(child);
                continue;
            }
            try {
                String value = child.getFirstChild().getNodeValue();
                this.setAttribute(nodeName.toUpperCase(), value);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addTaggedValues() {
        this.addTaggedValue("hierarchyLevel", String.valueOf(this.readIntValue("Level", 1)));
        this.addTaggedValue("type", this.getType());
    }
}

