/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer;

import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import ch.e2e.builder.compiler.document.importer.ImportContainer;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.util.StringTools;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class ImportTools {
    private static ImportTools importTools;

    private ImportTools() {
    }

    public static ImportTools getInstance() {
        if (importTools == null) {
            importTools = new ImportTools();
        }
        return importTools;
    }

    public static String createFilename(String filename, String orgExtension) {
        int index = filename.indexOf(".xml.zip");
        String newFilename = index == -1 ? ((index = filename.lastIndexOf(46)) == -1 || orgExtension.length() == 0 || !filename.endsWith(orgExtension) ? filename : filename.substring(0, index)) : filename.substring(0, index);
        if (newFilename.length() < 3) {
            newFilename = StringTools.append((String)newFilename, (int)3, (char)'_');
        }
        String newExtension = orgExtension == null ? "" : orgExtension;
        newFilename = ImportTools.findFilename(newFilename, newExtension);
        return newFilename;
    }

    public ArrayList<? extends ImportContainer> sortImportedElements(HashMap<String, ? extends ImportContainer> importedLibraries) {
        ArrayList<ImportContainer> result = new ArrayList<ImportContainer>();
        ArrayList<String> movedLibraries = new ArrayList<String>();
        while (importedLibraries.size() > 0) {
            ArrayList<String> librariesToMove = this.findElementsToMove(importedLibraries, movedLibraries);
            for (String library : librariesToMove) {
                result.add(0, importedLibraries.get(library));
                importedLibraries.remove(library);
                movedLibraries.add(library);
            }
        }
        return result;
    }

    private static String findFilename(String defaultFilename, String extension) {
        File srcFolder = new File(CompilerConstants.getProjectValue("uml"));
        String name = defaultFilename;
        File dest = new File(srcFolder, name + extension);
        int index = 0;
        while (dest.exists()) {
            name = defaultFilename + String.valueOf(++index);
            dest = new File(srcFolder, name + extension);
        }
        return dest.getName();
    }

    private ArrayList<String> findElementsToMove(HashMap<String, ? extends ImportContainer> importedElements, ArrayList<String> movedLibraries) {
        ArrayList<String> librariesToMove = new ArrayList<String>();
        for (ImportContainer importContainer : importedElements.values()) {
            boolean canMove = true;
            Collection<IDLImportSource> importSources = importContainer.getImportedElements();
            Iterator<IDLImportSource> libraryIterator = importSources.iterator();
            while (libraryIterator.hasNext() && canMove) {
                String name = libraryIterator.next().getName();
                canMove = movedLibraries.contains(name);
            }
            if (!canMove) continue;
            librariesToMove.add(importContainer.getName());
        }
        if (importedElements.size() > 0 && librariesToMove.size() == 0) {
            for (ImportContainer importContainer : importedElements.values()) {
                librariesToMove.add(importContainer.getName());
            }
        }
        return librariesToMove;
    }
}

