/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document;

import ch.e2e.builder.compiler.document.DependsFile;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DocumentInfo {
    private String xmiVersion;
    private boolean libraryImportDocument;
    private File infoFile;
    private DependsFile dependsFile;

    public DocumentInfo(File workingFolder) {
        this.infoFile = new File(workingFolder, ".document.info");
        if (this.infoFile.exists()) {
            try {
                this.readFile();
            }
            catch (Exception e) {
                this.infoFile.delete();
            }
        }
    }

    public boolean isLibraryImportDocument() {
        return this.libraryImportDocument;
    }

    public void setLibraryImportDocument(boolean libraryImportDocument) {
        this.libraryImportDocument = libraryImportDocument;
    }

    public String getXmiVersion() {
        return this.xmiVersion;
    }

    public void setXmiVersion(String xmiVersion) {
        this.xmiVersion = xmiVersion;
    }

    public void serialize() throws IOException, TransformerException {
        Document document = DomUtilities.newDocument((String)"DocumentInfo");
        document.getDocumentElement().setAttribute("version", this.xmiVersion);
        document.getDocumentElement().setAttribute("libraryImport", String.valueOf(this.libraryImportDocument));
        this.getDependsFile().serialize(document);
        DomUtilities.serialize((File)this.infoFile, (Document)document, (boolean)true);
    }

    public DependsFile getDependsFile() {
        if (this.dependsFile == null) {
            this.dependsFile = new DependsFile(null);
        }
        return this.dependsFile;
    }

    private void readFile() throws ParserConfigurationException, SAXException, IOException {
        Document info = DomUtilities.parse((File)this.infoFile, (boolean)false, (boolean)false);
        this.xmiVersion = info.getDocumentElement().getAttribute("version");
        this.libraryImportDocument = DomUtilities.getBoolean((Element)info.getDocumentElement(), (String)"libraryImport", (boolean)false);
        NodeList dependenciesList = info.getElementsByTagName("dependencies");
        Element dependencies = null;
        if (dependenciesList != null && dependenciesList.getLength() > 0) {
            dependencies = (Element)dependenciesList.item(0);
        }
        this.dependsFile = new DependsFile(dependencies);
    }
}

