/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.descriptor;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.compiler.build.types.BridgeInstanceController;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Composite;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.descriptor.DescriptorElement;
import ch.e2e.builder.compiler.descriptor.Library;
import ch.e2e.builder.compiler.descriptor.Logging;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.error.ConfigurationError;
import ch.e2e.builder.compiler.error.ConfigurationErrorHandler;
import ch.e2e.dom.DomUtilities;
import ch.e2e.swing.TreeObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RepositoryDescriptor
extends DescriptorElement
implements Comparable,
TreeObject {
    private String name;
    private String namespace;
    private String version;
    private ArrayList<Composite> composites;
    private UmlDocument umlDocument;
    private Document descriptorDocument;
    private boolean visible;
    private ArrayList<Library> libraries;
    private int hashCode;

    public RepositoryDescriptor(UmlDocument umlDocument, Document descriptorDocument) {
        super(descriptorDocument.getDocumentElement());
        this.umlDocument = umlDocument;
        this.descriptorDocument = descriptorDocument;
        this.reset(descriptorDocument);
    }

    public void reset(Document descriptorDocument) {
        this.clear(false);
        this.initialize(descriptorDocument.getDocumentElement());
        if (this.name == null) {
            this.name = this.umlDocument.getOriginalFile().getName();
        }
        ArrayList<String> addedDeployments = new ArrayList<String>();
        this.readComposites(descriptorDocument.getDocumentElement(), addedDeployments);
        this.readLibraries(descriptorDocument.getDocumentElement(), addedDeployments);
        Date creationTime = new Date();
        this.hashCode = (creationTime.getTime() + this.umlDocument.getUniqueId() + this.name).hashCode();
    }

    public int getType() {
        int result = 2000;
        int errorType = this.getErrorType();
        int deploymentErrorType = this.getDeploymentErrorType();
        if ((deploymentErrorType & 4) != 0) {
            result = 2005;
        } else if ((errorType & 8) != 0) {
            result = 2004;
        } else if ((errorType & 4) != 0) {
            result = 2003;
        } else if ((errorType & 2) != 0) {
            result = 2002;
        } else if ((errorType & 1) != 0) {
            result = 2001;
        }
        return result;
    }

    public Object getChild(int index) {
        Object result = index > -1 && index < this.composites.size() ? this.composites.get(index) : (index > -1 && index >= this.composites.size() && index < this.composites.size() + this.libraries.size() ? this.libraries.get(index - this.composites.size()) : "");
        return result;
    }

    public int getChildCount() {
        int result = this.composites == null ? 0 : this.composites.size();
        return result += this.libraries == null ? 0 : this.libraries.size();
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public int getIndexOfChild(Object child) {
        return this.indexOf((Composite)child);
    }

    @Override
    public UmlDocument getUmlDocument() {
        return this.umlDocument;
    }

    public boolean canBuild() {
        int i;
        boolean result = this.composites.size() > 0 || this.libraries.size() > 0;
        int length = this.composites.size();
        for (i = 0; i < length && result; ++i) {
            result = this.composites.get(i).canBuild();
        }
        length = this.libraries.size();
        for (i = 0; i < length && result; ++i) {
            result = this.libraries.get(i).canBuild();
        }
        return result;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void clear(boolean deleteErrorLogs) {
        int i;
        int length;
        if (this.composites != null) {
            length = this.composites.size();
            for (i = 0; i < length; ++i) {
                this.composites.get(i).clear(deleteErrorLogs);
            }
            this.composites.clear();
        }
        if (this.libraries != null) {
            length = this.libraries.size();
            for (i = 0; i < length; ++i) {
                this.libraries.get(i).clear(deleteErrorLogs);
            }
            this.libraries.clear();
        }
        super.clear();
    }

    public ArrayList<Composite> getComposites() {
        return this.composites;
    }

    public ArrayList<Library> getLibraries() {
        return this.libraries;
    }

    public int indexOf(Composite composite) {
        return this.composites.indexOf(composite);
    }

    public boolean isEmpty() {
        return !(this.composites != null && this.composites.size() != 0 || this.libraries != null && this.libraries.size() != 0);
    }

    public String getName() {
        return this.name;
    }

    public String getFullname() {
        return this.umlDocument.getUniqueId() + '.' + this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getVersion() {
        return this.version;
    }

    public Document getDescriptorDocument() {
        return this.descriptorDocument;
    }

    public ArrayList<Deployment> getAllDeployments() {
        ArrayList<Deployment> deployments = new ArrayList<Deployment>();
        for (Composite composite : this.composites) {
            deployments.addAll(composite.getDeployments());
        }
        return deployments;
    }

    public boolean hasDeployments() {
        boolean noDeployments = true;
        int length = this.composites.size();
        for (int i = 0; i < length && noDeployments; ++i) {
            Composite composite = this.composites.get(i);
            noDeployments = composite.getDeployments().size() == 0;
        }
        return !noDeployments;
    }

    public String toString() {
        return this.name;
    }

    @Override
    protected void initialize(Element xmlElement) {
        if (xmlElement != null) {
            super.initialize(xmlElement);
            this.readName(xmlElement);
            this.namespace = xmlElement.getNamespaceURI();
            this.version = xmlElement.getAttribute("version");
        }
    }

    private void readName(Element xmlElement) {
        if (xmlElement != null && xmlElement.hasAttribute("name")) {
            this.name = xmlElement.getAttribute("name");
        }
    }

    private void readComposites(Element xmlElement, ArrayList<String> addedDeployments) {
        this.composites = new ArrayList();
        NodeList configurationList = xmlElement.getElementsByTagName("Configuration");
        if (configurationList != null) {
            int length = configurationList.getLength();
            for (int i = 0; i < length; ++i) {
                Composite composite = new Composite((Element)configurationList.item(i), this.umlDocument);
                this.composites.add(composite);
                String xPath = "//Deployments/Deployment[@components='" + composite.getId() + "']";
                try {
                    NodeList result = (NodeList)DomUtilities.evaluate((Node)xmlElement, (String)xPath, (NamespaceContext)null, (QName)XPathConstants.NODESET);
                    if (result.getLength() == 0) {
                        this.addDeployments(xmlElement, Arrays.asList(composite.getId()), composite, addedDeployments);
                        continue;
                    }
                    this.addDeployments(result, composite, addedDeployments);
                    continue;
                }
                catch (XPathExpressionException e) {
                    Logging.logger.throwing(this.getClass().getName(), "addDeployments", e);
                }
            }
        }
    }

    private void addDeployments(NodeList result, CompilableObject compilableObject, ArrayList<String> addedDeployments) {
        int resultLength = result.getLength();
        for (int j = 0; j < resultLength; ++j) {
            String compilableObjectId = ((Element)result.item(j)).getAttribute("components");
            if (addedDeployments.contains(compilableObjectId)) continue;
            addedDeployments.add(compilableObjectId);
            compilableObject.addDeployment((Element)result.item(j));
        }
    }

    private void addDeployments(Element xmlElement, List<String> existingIds, CompilableObject compilableObject, ArrayList<String> addedDeployments) {
        for (String existingId : existingIds) {
            String xPath = "//Deployments/Deployment[Node/DeployedInstance/@idref='" + existingId + "']";
            try {
                NodeList result = (NodeList)DomUtilities.evaluate((Node)xmlElement, (String)xPath, (NamespaceContext)null, (QName)XPathConstants.NODESET);
                this.addDeployments(result, compilableObject, addedDeployments);
            }
            catch (XPathExpressionException e) {
                Logging.logger.throwing(this.getClass().getName(), "addDeployments", e);
            }
        }
    }

    private void readLibraries(Element xmlElement, ArrayList<String> addedDeployments) {
        this.libraries = new ArrayList();
        NodeList libraryList = xmlElement.getElementsByTagName("Library");
        if (libraryList != null) {
            int length = libraryList.getLength();
            for (int i = 0; i < length; ++i) {
                Element libraryElement = (Element)libraryList.item(i);
                Library library = new Library(libraryElement, this.umlDocument);
                this.libraries.add(library);
                String xPath = "//Deployments/Deployment[@components='" + library.getId() + "']";
                try {
                    NodeList result = (NodeList)DomUtilities.evaluate((Node)xmlElement, (String)xPath, (NamespaceContext)null, (QName)XPathConstants.NODESET);
                    if (result.getLength() == 0) {
                        this.addDeployments(xmlElement, library.getElementIds(), library, addedDeployments);
                    } else {
                        this.addDeployments(result, library, addedDeployments);
                    }
                }
                catch (XPathExpressionException e) {
                    Logging.logger.throwing(this.getClass().getName(), "addDeployments", e);
                }
                library.checkLibraryBackends(libraryElement);
            }
        }
    }

    public void distributeErrors(AbstractErrorHandler errorHandler) {
        for (BuilderError nextError : errorHandler.getAllErrorsAndWarnings()) {
            ConfigurationError error;
            String configurationName;
            Composite composite;
            if (!(nextError instanceof ConfigurationError) || (composite = this.findComposite(configurationName = (error = (ConfigurationError)nextError).getConfigurationName())) == null) continue;
            ConfigurationErrorHandler configErrors = composite.getErrorHandler();
            configErrors.addConfigurationError((BuilderError)error);
            configErrors.serialize(false);
        }
        errorHandler.serialize(false);
        for (Deployment deployment : this.getAllDeployments()) {
            deployment.clearAllErrors(true);
        }
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((RepositoryDescriptor)o).name);
    }

    public Set<CompilableObject> getCompilableObjects() {
        HashSet<CompilableObject> result = new HashSet<CompilableObject>();
        result.addAll(this.composites);
        result.addAll(this.libraries);
        return result;
    }

    public CompilableObject getCompilableObject(String name) {
        CompilableObject result = this.getComposite(name);
        if (result == null) {
            result = this.getLibrary(name);
        }
        return result;
    }

    public CompilableObject getComposite(String name) {
        Composite result = null;
        if (this.composites != null) {
            int length = this.composites.size();
            for (int i = 0; i < length && result == null; ++i) {
                Composite composite = this.composites.get(i);
                if (!composite.getName().equals(name)) continue;
                result = composite;
            }
        }
        return result;
    }

    public CompilableObject getLibrary(String name) {
        Library result = null;
        if (this.libraries != null) {
            int length = this.libraries.size();
            for (int i = 0; i < length && result == null; ++i) {
                Library library = this.libraries.get(i);
                if (!library.getName().equals(name)) continue;
                result = library;
            }
        }
        return result;
    }

    private Composite findComposite(String compositeName) {
        Composite result = null;
        if (this.composites != null) {
            int length = this.composites.size();
            for (int i = 0; i < length && result == null; ++i) {
                Composite composite = this.composites.get(i);
                if (!composite.getName().equals(compositeName)) continue;
                result = composite;
            }
        }
        return result;
    }

    private int getErrorType() {
        int errorType = 0;
        if (this.composites != null) {
            for (Composite configuration : this.composites) {
                errorType |= configuration.getErrorType();
            }
        }
        if (this.libraries != null) {
            for (Library library : this.libraries) {
                errorType |= library.getErrorType();
            }
        }
        return errorType;
    }

    private int getDeploymentErrorType() {
        int errorType = 0;
        if (this.composites != null) {
            for (Composite composite : this.composites) {
                for (Deployment deployment : composite.getDeployments()) {
                    errorType |= deployment.getDeployErrorHandler().getErrorType();
                }
            }
        }
        return errorType;
    }

    public boolean equals(Object obj) {
        return obj != null && super.equals(obj) && this.umlDocument.isActive() && obj instanceof RepositoryDescriptor && this.hashCode == ((RepositoryDescriptor)obj).hashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Iterator<Deployment> getDeploymentIterator() {
        return new DeploymentIterator();
    }

    public Iterator<Deployment> getRunningDeploymentIterator() {
        return new RunningDeploymentIterator();
    }

    private class RunningDeploymentIterator
    extends DeploymentIterator {
        private RunningDeploymentIterator() {
        }

        @Override
        protected void setNext(Deployment deployment) {
            if (BridgeInstanceController.getInstance().isRunning(deployment)) {
                super.setNext(deployment);
            }
        }
    }

    private class DeploymentIterator
    implements Iterator<Deployment> {
        int compositeCount = 0;
        int deploymentCount = 0;
        boolean hasNextCalled = false;
        Deployment next;

        private DeploymentIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this.hasNextCalled) {
                this.hasNextCalled = true;
                this.next = null;
                while (this.next == null && this.compositeCount < RepositoryDescriptor.this.composites.size()) {
                    ArrayList<Deployment> deployments = new ArrayList<Deployment>(((Composite)RepositoryDescriptor.this.composites.get(this.compositeCount)).getDeployments());
                    while (this.next == null && this.deploymentCount < deployments.size()) {
                        this.setNext(deployments.get(this.deploymentCount));
                        ++this.deploymentCount;
                    }
                    if (this.next != null) continue;
                    this.deploymentCount = 0;
                    ++this.compositeCount;
                }
            }
            return this.next != null;
        }

        @Override
        public Deployment next() {
            if (!this.hasNextCalled) {
                this.hasNext();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.hasNextCalled = false;
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void setNext(Deployment deployment) {
            this.next = deployment;
        }
    }
}

