/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.logger;

import ch.e2e.builder.compiler.build.types.logger.Filters;
import ch.e2e.builder.compiler.build.types.logger.Formatter;
import ch.e2e.builder.compiler.build.types.logger.Params;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.dom.DomUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Sink
extends RichElement {
    public static final String ELEMENT_NAME = "sink";
    public static final List<String> attributeNames = new ArrayList<String>(){
        {
            this.add("name");
            this.add("type");
        }
    };
    private Params params;
    private Filters filters;
    private Formatter formatter;

    public Sink() {
    }

    public Sink(Element tabfileElement) {
        super(tabfileElement);
        Iterator formatterIt = DomUtilities.elementIterator((NodeList)tabfileElement.getElementsByTagName("formatter"));
        while (formatterIt.hasNext()) {
            this.formatter = new Formatter((Element)formatterIt.next());
        }
        Iterator<Element> paramsIt = Sink.getElementIteratorByXPath(tabfileElement, "params");
        while (paramsIt.hasNext()) {
            this.params = new Params(paramsIt.next());
        }
        Iterator filtersIt = DomUtilities.elementIterator((NodeList)tabfileElement.getElementsByTagName("filters"));
        while (filtersIt.hasNext()) {
            this.filters = new Filters((Element)filtersIt.next());
        }
    }

    public void merge(Sink other) {
        this.params.merge(other.params);
        this.filters.merge(other.filters);
        this.formatter.merge(other.formatter);
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public List<String> getAttributeNames() {
        return attributeNames;
    }

    @Override
    protected void prepareChildren() {
        this.appendChildren(this.params, this.filters, this.formatter);
    }

    public JsonObjectBuilder buildJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("type", this.getAttributeValue("type"));
        if (this.params != null) {
            builder.add("params", this.params.buildJson());
        }
        if (this.filters != null) {
            builder.add("filters", this.filters.buildJson());
        }
        if (this.formatter != null) {
            builder.add("formatter", this.formatter.buildJson());
        }
        return builder;
    }
}

