/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.java;

import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.build.types.addons.java.Execute;
import ch.e2e.builder.compiler.build.types.addons.java.JavaVirtualMachine;
import ch.e2e.builder.compiler.build.types.substitutions.Variable;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BaseTabfile
extends XmlTabfile {
    private JavaVirtualMachine javaVirtualMachine;
    private Map<String, Execute> executors = new LinkedHashMap<String, Execute>();
    private boolean library = false;

    public BaseTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
    }

    @Override
    public void doMergePostProcess(SubstitutionsTabfile substitutions, boolean library) throws XPathExpressionException {
        if (this.javaVirtualMachine != null) {
            Collection<Variable> allVariables = substitutions.getVariables().values();
            for (Variable v : allVariables) {
                if (!v.getName().startsWith("ALIAS_VirtualMachine_Options_Option")) continue;
                this.javaVirtualMachine.addOption("${" + v.getName() + "}");
            }
        }
        this.library = library;
        super.doMergePostProcess(substitutions, library);
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        Element replaced = (Element)this.doReplace(table, configurationElement, compilableObject);
        NodeList vms = replaced.getElementsByTagName("VirtualMachine");
        if (vms.getLength() > 0) {
            if (this.javaVirtualMachine == null) {
                this.javaVirtualMachine = new JavaVirtualMachine();
            }
            Iterator vmIterator = DomUtilities.elementIterator((NodeList)vms);
            while (vmIterator.hasNext()) {
                this.javaVirtualMachine.mergeIn((Element)vmIterator.next());
            }
        }
        Iterator execIterator = DomUtilities.elementIterator((NodeList)replaced.getElementsByTagName("Execute"));
        while (execIterator.hasNext()) {
            this.addExecute((Element)execIterator.next());
        }
        return true;
    }

    private void addExecute(Element executeElement) {
        Execute newExecute = new Execute(executeElement);
        Execute existingExecute = this.executors.get(newExecute.getRequestName());
        if (existingExecute != null) {
            existingExecute.mergeIn(newExecute);
        } else {
            this.executors.put(newExecute.getRequestName(), newExecute);
        }
    }

    @Override
    public void beforeSerialize(ZipOutputStream zipOut, String fileName, Boolean library) throws Exception {
        this.prepareDocument();
        super.beforeSerialize(zipOut, fileName, library);
    }

    void prepareDocument() {
        this.setTabfileDocument(null);
        Document tabfile = this.getDocument();
        this.javaVirtualMachine.buildDom(tabfile.getDocumentElement(), this.library);
        for (Execute execute : this.executors.values()) {
            execute.buildDom(tabfile.getDocumentElement(), this.library);
        }
    }
}

