/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.E2EBuilderDataType;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Composite;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.descriptor.RepositoryResource;
import ch.e2e.builder.compiler.document.UmlDocumentCompilerSettings;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Repository
implements E2EBuilderDataType {
    private CompilableObject compilableObject;

    public Repository(CompilableObject configuration) {
        this.compilableObject = configuration;
    }

    public File getTabfileContainer(String deployment) {
        return new File(this.compilableObject.getUmlDocument().getDocumentWorkingFolder(), deployment + (this.compilableObject instanceof Composite ? ".composite.tabfiles" : ".library.tabfiles"));
    }

    public File getTargetFile(Deployment deployment) {
        return deployment.getTargetFile();
    }

    @Override
    public boolean isUpToDate(CompilableObject configuration) {
        boolean result = true;
        Iterator<Deployment> deployments = this.compilableObject.getDeployments().iterator();
        while (deployments.hasNext() && result) {
            Deployment deployment = deployments.next();
            File targetFile = this.getTargetFile(deployment);
            result = targetFile.exists() && this.checkSources(targetFile, deployment);
        }
        return result;
    }

    public Document getDeployDocument(String deployment) throws IOException, ParserConfigurationException, SAXException {
        File deployFile = this.getDeployFile(deployment);
        return DomUtilities.parse((File)deployFile, (boolean)false, (boolean)false);
    }

    private File getDeployFile(String deployment) {
        if (this.compilableObject.getDeployment(deployment) != null) {
            return this.compilableObject.getDeployment(deployment).getDeployFile();
        }
        return new File(this.compilableObject.getUmlDocument().getDocumentWorkingFolder(), deployment + ".deploy");
    }

    public Document getAsynchronousTraceDocument(String deployment) throws IOException, ParserConfigurationException, SAXException {
        File traceFile = new File(this.compilableObject.getUmlDocument().getDocumentWorkingFolder(), deployment + ".asynchronous.trace");
        Document result = null;
        if (traceFile.exists()) {
            result = DomUtilities.parse((File)traceFile, (boolean)false, (boolean)false);
        }
        return result;
    }

    private boolean checkSources(File targetFile, Deployment deployment) {
        File tabfileContainer = this.getTabfileContainer(deployment.getName());
        boolean result = tabfileContainer.lastModified() < targetFile.lastModified();
        boolean bl = tabfileContainer.lastModified() < this.getDeployFile(deployment.getName()).lastModified();
        UmlDocumentCompilerSettings settings = deployment.getUmlDocument().getSettings();
        if ((result &= bl) && this.compilableObject.containsJavaService()) {
            result = this.checkFiles(this.compilableObject.getJarfilesToDeploy(), settings.getJarFolder(), targetFile);
            result &= this.checkFiles(this.compilableObject.getXarfilesToDeploy(), settings.getXSLTFolder(), targetFile);
            result &= this.checkFiles(this.compilableObject.getXSLTScripts(), settings.getXSLTFolder(), targetFile);
        }
        File resourcesHome = settings.getResourceFolder();
        resourcesHome = new File(resourcesHome, this.compilableObject.getUmlDocument().getDocumentName());
        return result &= this.checkFiles(this.compilableObject.getResources(), new File(resourcesHome, deployment.getName()), targetFile);
    }

    private boolean checkFiles(ArrayList<RepositoryResource> resources, File dir, File targetFile) {
        boolean result = true;
        int length = resources.size();
        for (int i = 0; i < length && result; ++i) {
            RepositoryResource resource = resources.get(i);
            result = resource.getTargetFile(dir).lastModified() < targetFile.lastModified();
        }
        return result;
    }

    private boolean checkFiles(String[] filenames, File dir, File targetFile) {
        boolean result = true;
        for (int i = 0; i < filenames.length && result; ++i) {
            File file = new File(dir, filenames[i]);
            result = file.lastModified() < targetFile.lastModified();
        }
        return result;
    }

    public Collection<Deployment> getDeployments() {
        return this.compilableObject.getDeployments();
    }
}

