/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.source;

import ch.e2e.builder.compiler.build.tasks.source.SourceFactory;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.TaskFactory;
import ch.e2e.builder.compiler.build.tasks.source.TaskSourceSetFactory;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.IntStream;

public class SourceManagerFactory {
    private final LinkedList<SourceFactory> sourceFactories = new LinkedList();
    private final LinkedList<TaskFactory> taskFactories = new LinkedList();
    private final Set<TaskSourceSetFactory> taskSourceSetFactories = new HashSet<TaskSourceSetFactory>();

    public SourceManager createSourceManager(File projectFolder) {
        return new SourceManager(projectFolder, this.sourceFactories, this.taskFactories, this.taskSourceSetFactories);
    }

    public void addSourceFactory(SourceFactory sourceFactory) {
        double priority = sourceFactory.getPriority();
        int index = IntStream.range(0, this.sourceFactories.size()).filter(i -> this.sourceFactories.get(i).getPriority() < priority).findFirst().orElse(this.sourceFactories.size());
        this.sourceFactories.add(index, sourceFactory);
    }

    public void addTaskFactory(TaskFactory taskFactory) {
        double priority = taskFactory.getPriority();
        int index = IntStream.range(0, this.taskFactories.size()).filter(i -> this.taskFactories.get(i).getPriority() < priority).findFirst().orElse(this.taskFactories.size());
        this.taskFactories.add(index, taskFactory);
    }

    public void addTaskSourceSetFactory(TaskSourceSetFactory taskSourceSetFactoryFactory) {
        this.taskSourceSetFactories.add(taskSourceSetFactoryFactory);
    }
}

