/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.jars;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.source.JarSourceFile;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.build.tasks.uml.UmlHelper;
import ch.e2e.builder.compiler.document.importer.java.JavaImportSource;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JarComponentsTask
extends CacheAbleTask
implements XSLTTransformSource {
    private Document result;

    public static Boolean select(String id) {
        return id.endsWith(Extensions._jar_components_xml);
    }

    public JarComponentsTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._jar_components_xml;
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> sourceSet = new HashSet<String>();
        sourceSet.add(this.getSourceId());
        return sourceSet;
    }

    protected String getSourceId() {
        return Folders.jars_ + this.getDestinationFileNameWithoutExtension() + Extensions._jar;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            JarSourceFile jarSource = (JarSourceFile)this.getSource(this.getSourceId());
            JavaImportSource javaImportSource = (JavaImportSource)jarSource.getImporterData().getSource("java.import.source");
            Document document = DomUtilities.newDocument((String)"http://scheer-group.com/xuml", (String)"xuml:components");
            Element components = document.getDocumentElement();
            Element module = document.createElementNS("http://scheer-group.com/xuml", "xuml:module");
            components.appendChild(module);
            module.appendChild(javaImportSource.getDataModel().getModule().toXmi(document, javaImportSource.getDataModel().getModelId(), UmlHelper.getWorkUmlFolder(this.getSourceManager().getWorkFolder()).getPath()));
            DomUtilities.serialize((File)this.getDestinationFile(), (Document)document, (boolean)true);
            this.result = document;
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

