/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.libraries;

import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.compiler.assetRepository.AssetRepositoryService;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.error.TaskFatalError;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.TaskFactory;
import ch.e2e.builder.compiler.document.json.xuml.XumlLibraryUsage;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class DownloadLibraryTask
extends CacheAbleTask {
    private final AssetRepositoryService assetRepositoryService;

    public DownloadLibraryTask(SourceManager sourceManager, String id, AssetRepositoryService assetRepositoryService) {
        super(sourceManager, id);
        this.assetRepositoryService = assetRepositoryService;
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getSourceId());
        return result;
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._library_xlib;
    }

    private String getSourceId() {
        return ch.e2e.builder.compiler.build.tasks.constants.Files.libs__LIBRARY_library_xml(this.getDestinationFileNameWithoutExtension());
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            JsonDocumentSource source = (JsonDocumentSource)this.getSource(this.getSourceId());
            if (source == null) {
                return;
            }
            XumlLibraryUsage libraryUsage = source.getJsonDocument(XumlLibraryUsage.class);
            try (InputStream xlib = this.assetRepositoryService.getXlib(libraryUsage.getRepository(), libraryUsage.getName(), libraryUsage.getVersion());){
                if (xlib == null) {
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("name", libraryUsage.getName());
                    parameters.put("version", libraryUsage.getVersion());
                    parameters.put("repository", libraryUsage.getRepository());
                    this.getErrorHandler().fatalError((BuilderFatalError)new TaskFatalError("FLIB0001", parameters));
                } else {
                    this.getDestinationFile().getParentFile().mkdirs();
                    Files.copy(xlib, this.getDestinationFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public boolean isUpToDate() {
        return !this.getErrorHandler().hasErrors() && super.isUpToDate();
    }

    public static class Factory
    extends TaskFactory {
        AssetRepositoryService assetRepositoryService;

        public Factory(AssetRepositoryService assetRepositoryService, Double priority) {
            super(priority);
            this.assetRepositoryService = assetRepositoryService;
        }

        @Override
        public Boolean matchId(String id) {
            return id.endsWith(Extensions._library_xlib);
        }

        @Override
        public CacheAbleTask createTask(String id, SourceManager sourceManager) {
            return new DownloadLibraryTask(sourceManager, id, this.assetRepositoryService);
        }
    }
}

