/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.message.SendStatusEvent;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CompilerTask;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.Task;
import ch.e2e.builder.compiler.build.tasks.Xmi2ExmiTask;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.types.ImportDocument;
import ch.e2e.builder.compiler.document.DependsFile;
import ch.e2e.builder.compiler.document.IncludesFile;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.error.DefaultCompilerError;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.logging.PerformanceLogger;
import ch.e2e.util.VersionChecker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ExmiWithImportTask
extends CompilerTask {
    private Document sourceDocument;
    private File dest;

    public ExmiWithImportTask() {
        super(new CompileControl[0]);
    }

    @Override
    protected void propagateErrors() {
        super.propagateErrors();
        if (this.getUmlDocument() != null) {
            this.getErrorHandler().addTo((AbstractErrorHandler)this.getUmlDocument().getEXMIErrorHandler());
            this.getUmlDocument().getEXMIErrorHandler().serialize(false);
        }
    }

    public void setSourceDocument(Document sourceDocument) {
        this.sourceDocument = sourceDocument;
    }

    public Document getSourceDocument() throws ParserConfigurationException, SAXException, IOException {
        Document source = this.sourceDocument;
        if (source == null && this.getUmlDocument() != null) {
            source = this.getSourceFromBridgeXmiFile();
        }
        return source;
    }

    private Document getSourceFromBridgeXmiFile() throws IOException, SAXException, ParserConfigurationException {
        File sourceFile;
        if (this.getUmlDocument() != null && (sourceFile = this.getUmlDocument().getBridgeXmiFile()) != null && sourceFile.exists()) {
            return DomUtilities.parse((File)sourceFile, (boolean)false, (boolean)false, (boolean)false);
        }
        return null;
    }

    public File getDest() {
        return this.dest;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        UmlDocument umlDocument = this.getUmlDocument();
        if (umlDocument == null) {
            throw new BuildException("UmlDocument not defined for task: " + this.getClass().getSimpleName());
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("document.name", umlDocument.getDocumentName());
        parameters.put("absolute path", umlDocument.getAbsolutePath());
        SendStatusEvent event = new SendStatusEvent((Object)this, "status.creating.bridge.xmi", parameters);
        EventController.fire((EventObject)event);
        try {
            Document sourceDocument = this.getSourceDocument();
            if (sourceDocument == null) {
                throw new BuildException("Unable to find source for compiler task: " + this.getClass().getSimpleName());
            }
            Document result = this.createXmiDocument(sourceDocument);
            result.getDocumentElement().setAttribute("xmlns:xuml", "http://scheer-group.com/xuml");
            DomUtilities.serialize((File)umlDocument.getBridgeXmiWithImportsFile(), (Document)result, (boolean)false);
            if (this.getDest() != null) {
                DomUtilities.serialize((File)this.getDest(), (Document)result, (boolean)true);
            }
            this.printResult(result);
        }
        catch (SAXParseException ex) {
            DefaultCompilerError error = new DefaultCompilerError("error.could.not.parse.document", parameters);
            this.getErrorHandler().error((AbstractBuilderError)error);
        }
        catch (Exception ex) {
            this.showFatalError(ex.getMessage() == null ? "null" : ex.getMessage());
            throw new BuildException(ex);
        }
    }

    private DependsFile getDependsFile() {
        return this.getUmlDocument().getDocumentInfo().getDependsFile();
    }

    private Document createXmiDocument(Document xmlDocument) throws IOException, ParserConfigurationException, SAXException {
        long start = PerformanceLogger.start((String)"BridgeXmiFile.createXmiDocument", (String)this.getUmlDocument().getAbsolutePath());
        Element imports = xmlDocument.createElement("XMI_imports");
        this.importDependingFiles(imports);
        xmlDocument.getDocumentElement().appendChild(imports);
        PerformanceLogger.stop((String)"BridgeXmiFile.createXmiDocument", (String)this.getUmlDocument().getAbsolutePath(), (long)start);
        return xmlDocument;
    }

    private void importDependingFiles(Element imports) throws IOException, ParserConfigurationException, SAXException {
        Element idTable = imports.getOwnerDocument().createElement("idtable");
        imports.appendChild(idTable);
        HashMap<String, ImportDocument> importedDocuments = new HashMap<String, ImportDocument>();
        UmlDocument bridgeBase = this.getUmlDocumentFactory().getBridgeBaseDocument();
        importedDocuments.put(bridgeBase.getUniqueId(), new ImportDocument(bridgeBase));
        ArrayList<String> importedIDs = new ArrayList<String>();
        HashMap<String, Element> elementsToImport = new HashMap<String, Element>();
        for (IncludesFile includesFile : this.getDependsFile().getIncludesFiles().values()) {
            this.readDependingFile(includesFile, importedIDs, elementsToImport, importedDocuments);
        }
        this.readImportedLibraryElements(importedIDs, elementsToImport, importedDocuments);
        this.importElements(elementsToImport, imports);
        for (ImportDocument importDocument : importedDocuments.values()) {
            Element file = imports.getOwnerDocument().createElement("file");
            file.setAttribute("id", importDocument.getUmlDocument().getUniqueId());
            file.setAttribute("name", importDocument.getUmlDocument().getOriginalFile().getName());
            file.setAttribute("path", importDocument.getUmlDocument().getAbsolutePath());
            idTable.appendChild(file);
        }
    }

    private void readDependingFile(IncludesFile includesFile, List<String> importedIDs, Map<String, Element> elementsToImport, Map<String, ImportDocument> importedDocuments) throws IOException, ParserConfigurationException, SAXException {
        ImportDocument importedDocument = this.getImportDocument(includesFile.getUmlFileID(), importedDocuments);
        if (importedDocument != null && importedDocument.exists() && VersionChecker.checkVersion((String)"2.1", (String)importedDocument.getXmiVersion())) {
            this.findElementsToImport(importedDocument, importedIDs, elementsToImport, includesFile, importedDocuments);
            this.addLibraryElements(importedDocument, importedIDs, elementsToImport);
        }
    }

    private ImportDocument getImportDocument(String umlFileID, Map<String, ImportDocument> importedDocuments) {
        UmlDocument importedUmlDocument;
        ImportDocument importedDocument = importedDocuments.get(umlFileID);
        if (importedDocument == null && (importedUmlDocument = this.getUmlDocumentFactory().getUmlDocumentById(umlFileID)) != null) {
            importedDocument = new ImportDocument(importedUmlDocument);
            importedDocuments.put(umlFileID, importedDocument);
        }
        return importedDocument;
    }

    private void findElementsToImport(ImportDocument importDocument, List<String> importedIDs, Map<String, Element> elementsToImport, IncludesFile includesFile, Map<String, ImportDocument> importedDocuments) throws IOException, ParserConfigurationException, SAXException {
        for (String id : includesFile.getXmiElementIDs()) {
            this.findElement(importDocument, id, importedIDs, elementsToImport, importedDocuments);
        }
    }

    private void findElement(ImportDocument importDocument, String id, List<String> importedIDs, Map<String, Element> elementsToImport, Map<String, ImportDocument> importedDocuments) throws IOException, ParserConfigurationException, SAXException {
        Element importedElement;
        if (!importedIDs.contains(id) && (importedElement = importDocument.getElement(id)) != null) {
            String localName = importedElement.getLocalName();
            if (localName != null) {
                if (localName.equals("ownedOperation")) {
                    Element parent = (Element)importedElement.getParentNode();
                    String elementType = parent.getAttribute("xmi:type");
                    while ("uml:Class".equals(elementType) || "uml:Interface".equals(elementType)) {
                        importedElement = parent;
                        localName = importedElement.getLocalName();
                        parent = (Element)importedElement.getParentNode();
                        elementType = parent.getAttribute("xmi:type");
                    }
                }
                while (localName.startsWith("nested")) {
                    importedElement = (Element)importedElement.getParentNode();
                    localName = importedElement.getLocalName();
                }
            }
            id = importedElement.getAttribute("xmi:id");
            importedIDs.add(id);
            elementsToImport.put(id, importedElement);
            this.findDependingElements(importDocument, importedElement, importedIDs, elementsToImport, importedDocuments);
        }
    }

    private void findDependingElements(ImportDocument importDocument, Element importedElement, List<String> importedIDs, Map<String, Element> elementsToImport, Map<String, ImportDocument> importedDocuments) throws IOException, ParserConfigurationException, SAXException {
        NamedNodeMap attributes = importedElement.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (attribute.getName().equals("xmi:id")) continue;
            this.findReferencedElement(importDocument, importedIDs, elementsToImport, importedDocuments, attribute);
        }
        Iterator childIt = DomUtilities.elementIterator((NodeList)importedElement.getChildNodes());
        while (childIt.hasNext()) {
            Element child = (Element)childIt.next();
            String childId = child.getAttribute("xmi:id");
            if (childId.isEmpty() && "uml:Usage".equals(importedElement.getAttribute("xmi:type"))) {
                if ("supplier".equals(child.getLocalName())) {
                    this.findElement(importDocument, child.getAttribute("xmi:idref"), importedIDs, elementsToImport, importedDocuments);
                }
                this.findElement(importDocument, importedElement.getAttribute("supplier"), importedIDs, elementsToImport, importedDocuments);
            }
            if (elementsToImport.remove(childId) == null && !importedIDs.contains(childId)) {
                importedIDs.add(childId);
                this.findDependingElements(importDocument, child, importedIDs, elementsToImport, importedDocuments);
            }
            if (!child.hasAttribute("xmi:idref")) continue;
            Attr attribute = child.getAttributeNode("xmi:idref");
            this.findReferencedElement(importDocument, importedIDs, elementsToImport, importedDocuments, attribute);
        }
        List<String> subclasses = importDocument.getSubclasses(importedElement.getAttribute("xmi:id"));
        for (String subclass : subclasses) {
            this.findElement(importDocument, subclass, importedIDs, elementsToImport, importedDocuments);
        }
        if ("uml:Interface".equals(importedElement.getAttribute("xmi:type"))) {
            try {
                NodeList responseDefinitions = (NodeList)DomUtilities.evaluate((Node)importedElement.getOwnerDocument().getDocumentElement(), (String)"//*[ebp:RESTResponseDefinition]", (QName)XPathConstants.NODESET);
                Iterator it = DomUtilities.elementIterator((NodeList)responseDefinitions);
                while (it.hasNext()) {
                    Element definitionElement = (Element)it.next();
                    String definitionElementId = definitionElement.getAttribute("xmi:id");
                    this.findElement(importDocument, definitionElementId, importedIDs, elementsToImport, importedDocuments);
                }
            }
            catch (XPathExpressionException e) {
                Logging.logger.severe("XPath failed even though it really shouldn't");
                Logging.logger.throwing(ExmiWithImportTask.class.getName(), "findDependingElements", e);
            }
        }
    }

    private void findReferencedElement(ImportDocument importDocument, List<String> importedIDs, Map<String, Element> elementsToImport, Map<String, ImportDocument> importedDocuments, Attr attribute) throws IOException, ParserConfigurationException, SAXException {
        if (attribute.getValue().startsWith(importDocument.getUmlPrefix())) {
            this.findElement(importDocument, attribute.getValue(), importedIDs, elementsToImport, importedDocuments);
        } else {
            String id;
            ImportDocument dependingImport;
            String value = attribute.getValue();
            int index = value.indexOf(124);
            if (index != -1 && (dependingImport = this.getImportDocument(id = value.substring(0, index), importedDocuments)) != null) {
                this.findElement(dependingImport, attribute.getValue(), importedIDs, elementsToImport, importedDocuments);
            }
        }
    }

    private void addLibraryElements(ImportDocument importedDocument, List<String> importedIDs, Map<String, Element> elementsToImport) throws IOException, ParserConfigurationException, SAXException {
        for (String id : importedDocument.getLibraryElements().keySet()) {
            if (importedIDs.contains(id)) continue;
            importedIDs.add(id);
            elementsToImport.put(id, importedDocument.getLibraryElements().get(id));
        }
    }

    private void readImportedLibraryElements(List<String> importedIDs, Map<String, Element> elementsToImport, Map<String, ImportDocument> importedDocuments) throws IOException, ParserConfigurationException, SAXException {
        for (String id : this.getDependsFile().getMountedDocuments()) {
            UmlDocument document = this.getUmlDocumentFactory().getUmlDocumentById(id);
            if (document == null || !document.getDocumentInfo().isLibraryImportDocument()) continue;
            ImportDocument importedDocument = this.getImportDocument(id, importedDocuments);
            this.addLibraryElements(importedDocument, importedIDs, elementsToImport);
        }
    }

    private void importElements(Map<String, Element> elementsToImport, Element imports) {
        for (Element element : elementsToImport.values()) {
            String location = this.createLocation(element);
            Node importElement = imports.getOwnerDocument().importNode(element, true);
            Element locationElement = imports.getOwnerDocument().createElementNS("http://e2e.ch/bridge/profile", "ebp:errorLocation");
            locationElement.setAttribute("value", location);
            if (importElement.hasChildNodes()) {
                importElement.insertBefore(locationElement, importElement.getFirstChild());
            } else {
                importElement.appendChild(locationElement);
            }
            imports.appendChild(importElement);
        }
    }

    private String createLocation(Element element) {
        StringBuilder location = new StringBuilder(element.getAttribute("xmi:id"));
        Node parent = element.getParentNode();
        while (parent instanceof Element) {
            String xmiId = ((Element)parent).getAttribute("xmi:id");
            if (!xmiId.isEmpty()) {
                location.insert(0, xmiId + '~');
            }
            parent = parent.getParentNode();
        }
        return location.toString();
    }

    @Override
    public boolean isUpToDate() {
        if (this.getUmlDocument() != null) {
            boolean result;
            File targetFile = this.getUmlDocument().getBridgeXmiWithImportsFile();
            if (!targetFile.exists()) {
                return false;
            }
            Iterator<Task> tasks = this.getDependsOnTasksIterator();
            long srcModified = this.getUmlDocument().getBridgeXmiFile().lastModified();
            long targetModified = targetFile.lastModified();
            boolean bl = result = targetModified > srcModified;
            while (result && tasks.hasNext()) {
                Task task = tasks.next();
                if (!(task instanceof Xmi2ExmiTask)) continue;
                UmlDocument includeDoc = ((CompilerTask)task).getUmlDocument();
                result = includeDoc.getBridgeXmiFile().lastModified() < targetModified;
            }
            return result;
        }
        return false;
    }
}

