/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.base.message.SendFatalErrorEvent;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.Task;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.logging.PerformanceLogger;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public abstract class CompilerTask
extends Task {
    static final String ERROR_CODE_COULD_NOT_PARSE_DOCUMENT = "error.could.not.parse.document";
    private AbstractErrorHandler errorHandler;
    private UmlDocument umlDocument;

    protected CompilerTask(CompileControl ... compileControls) {
        super(compileControls);
    }

    UmlDocumentFactory getUmlDocumentFactory() {
        return this.umlDocument.getUmlDocumentFactory();
    }

    public UmlDocument getUmlDocument() {
        return this.umlDocument;
    }

    public void setUmlDocument(UmlDocument umlDocument) {
        this.umlDocument = umlDocument;
    }

    public void setErrorHandler(AbstractErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public AbstractErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new AbstractErrorHandler(new File(new File(this.umlDocument.getDocumentWorkingFolder(), "errorlog"), this.getClass().getSimpleName() + ".errors")){};
        }
        return this.errorHandler;
    }

    @Override
    public String getTaskSourceName() {
        return this.getUmlDocument().getAbsolutePath();
    }

    @Override
    protected void propagateErrors() {
        this.getErrorHandler().serialize(false);
    }

    @Override
    protected abstract void executeTask(int var1) throws BuildException;

    protected String getCompilerId() {
        return this.getClass().getSimpleName();
    }

    void showError(String messageKey) {
        EventController.fire((EventObject)new SendErrorEvent((Object)this, messageKey, null, "compiler", "compiler.message.view"));
    }

    void showFatalError(String messageKey) {
        EventController.fire((EventObject)new SendFatalErrorEvent((Object)this, messageKey, null, "compiler", "compiler.message.view"));
    }

    public String toString() {
        return this.getCompilerId();
    }

    void printResult(Node result) throws TransformerException, IOException {
        if (Boolean.getBoolean("ch.e2e.builder.development") || this.isDebug().booleanValue()) {
            File folder = new File(".");
            String filename = "debug";
            String taskSource = "";
            if (this.getUmlDocument() != null) {
                folder = this.getUmlDocument().getDocumentWorkingFolder();
                filename = this.getUmlDocument().getOriginalFile().getName();
                taskSource = this.getUmlDocument().getAbsolutePath();
            }
            long start = PerformanceLogger.start((String)"CompilerTask.print.development.file", (String)taskSource);
            File file = new File(folder, filename + '.' + this.getClass().getSimpleName());
            DomUtilities.serialize((File)file, (Node)result, (boolean)true);
            PerformanceLogger.stop((String)"CompilerTask.print.development.file", (String)taskSource, (long)start);
        }
    }

    @Override
    public String getName() {
        if (this.getUmlDocument() != null) {
            return super.getName() + ":" + this.getUmlDocument().getName();
        }
        return super.getName();
    }
}

