/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.request;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.request.AbstractRequest;
import ch.e2e.builder.trace.request.Logging;
import ch.e2e.builder.trace.request.RequestClient;
import ch.e2e.builder.trace.request.RequestException;
import org.w3c.dom.Document;

public abstract class AbstractRequestTransaction
extends E2EBuilderTransaction {
    private E2EBuilderModule module;

    public AbstractRequestTransaction(E2EBuilderModule traceViewer) {
        this.module = traceViewer;
    }

    public String getDescription() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public E2EBuilderModule getModule() {
        return this.module;
    }

    public Object doTransaction(Object transactionData) throws Throwable {
        long start = System.currentTimeMillis();
        AbstractRequest request = (AbstractRequest)transactionData;
        Document response = this.performRequest(request);
        long stop = System.currentTimeMillis();
        String msg = "Done. " + (stop - start) + " ms";
        request.setResponse(response);
        Logging.logger.finer(msg);
        this.showStatus(msg);
        return request;
    }

    protected abstract void showStatus(String var1);

    protected abstract void showError(Throwable var1);

    protected void showErrorDialog(Throwable error) {
        if (error instanceof RequestException) {
            E2EBuilderInfoDialog.error((String)this.module.getTranslation(((RequestException)error).getTitle(), ((RequestException)error).getTitle()), (String)this.module.getTranslation(((RequestException)error).getSubtitle(), ((RequestException)error).getSubtitle()), (String)this.getErrorMessage(error));
        } else {
            E2EBuilderInfoDialog.error((String)this.getErrorMessage(error));
        }
    }

    protected Document performRequest(AbstractRequest request) throws Exception {
        return RequestClient.getInstance().performRequest(request);
    }

    public void setTransactionResult(Object result) {
    }

    public boolean doErrorHandling(Throwable error) {
        Logging.logger.throwing(((Object)((Object)this)).getClass().getName(), "doErrorHandling", error);
        this.showError(error);
        this.showErrorDialog(error);
        return false;
    }

    public void prepareTransaction() {
    }

    protected String getErrorMessage(Throwable error) {
        return error instanceof NullPointerException ? error.getClass().getName() : error.getMessage();
    }
}

