/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.state;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.gui.uml.UmlCell;
import ch.e2e.builder.trace.gui.uml.UmlCellViewFactory;
import ch.e2e.builder.trace.gui.uml.UmlGraph;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.gui.uml.activity.DecisionCell;
import ch.e2e.builder.trace.gui.uml.activity.FinalNodeCell;
import ch.e2e.builder.trace.gui.uml.activity.InfoCell;
import ch.e2e.builder.trace.gui.uml.activity.InitialNodeCell;
import ch.e2e.builder.trace.gui.uml.activity.UnfoldedBranchesEdge;
import ch.e2e.builder.trace.gui.uml.state.AbstractStateCell;
import ch.e2e.builder.trace.gui.uml.state.CompositeCell;
import ch.e2e.builder.trace.gui.uml.state.EntryCell;
import ch.e2e.builder.trace.gui.uml.state.ExitCell;
import ch.e2e.builder.trace.gui.uml.state.ForkOrJoinCell;
import ch.e2e.builder.trace.gui.uml.state.HistoryCell;
import ch.e2e.builder.trace.gui.uml.state.SignalCell;
import ch.e2e.builder.trace.gui.uml.state.StateCell;
import ch.e2e.builder.trace.gui.uml.state.TerminateCell;
import ch.e2e.builder.trace.gui.uml.state.TransitionEdge;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.uml.Branches;
import ch.e2e.builder.trace.testcase.uml.DefaultAction;
import ch.e2e.builder.trace.testcase.uml.DeleteStateObject;
import ch.e2e.builder.trace.testcase.uml.DoAction;
import ch.e2e.builder.trace.testcase.uml.EntryAction;
import ch.e2e.builder.trace.testcase.uml.Event;
import ch.e2e.builder.trace.testcase.uml.ExitAction;
import ch.e2e.builder.trace.testcase.uml.GenericFlow;
import ch.e2e.builder.trace.testcase.uml.ParentState;
import ch.e2e.builder.trace.testcase.uml.SourceState;
import ch.e2e.builder.trace.testcase.uml.SourceStateParent;
import ch.e2e.builder.trace.testcase.uml.State;
import ch.e2e.builder.trace.testcase.uml.StateTransition;
import ch.e2e.builder.trace.testcase.uml.TargetState;
import ch.e2e.builder.trace.testcase.uml.TargetStateParent;
import ch.e2e.builder.trace.testcase.uml.TransitionAction;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlObjectVisitor;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import java.awt.geom.Rectangle2D;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public class StateGraphBuilder
extends UmlObjectVisitor {
    private static final String STATE_DIAGRAM_TITLE = "Current State History";
    private static final double X = 100.0;
    private static final double DX = 150.0;
    private static final double DY = 50.0;
    private Testcase testcase;
    private UmlObject root;
    private E2ETraceModule module;
    private DefaultGraphModel model;
    private UmlGraph graph;
    private CellMap cells = new CellMap();
    private StateTransition transition;
    private Event event;
    private State sourceState;
    private State targetState;
    private ParentState parentState;
    private GenericFlow transitionFlow;
    private GenericFlow entryFlow;
    private GenericFlow exitFlow;
    private Map<String, Deque<GenericFlow>> doFlows = new HashMap<String, Deque<GenericFlow>>();
    private Map<String, Deque<Branches>> choices = new HashMap<String, Deque<Branches>>();
    private DefaultGraphCell sourceCell;
    private DefaultGraphCell targetCell;
    private double y;
    private double x = 100.0;
    private SignalCell signalCell;

    public StateGraphBuilder(Testcase testcase, UmlObject root, E2ETraceModule module) {
        this.testcase = testcase;
        this.root = root;
        this.module = module;
        this.initializeGraph();
        this.createInfoCell();
        this.visit(root);
        this.insertDoFlows();
        if (this.signalCell != null) {
            double w = UmlGraphConstants.getBounds((Map)this.signalCell.getAttributes()).getWidth();
            this.signalCell.getAttributes().translate(100.0 - 0.5 * w, this.y + 100.0);
        }
        this.graph.getGraphLayoutCache().insert(this.getCells());
        this.graph.setRunDate(new Date().getTime());
    }

    public UmlGraph getGraph() {
        return this.graph;
    }

    public Object[] getCells() {
        return this.cells.values().toArray();
    }

    public void doLayout() {
        this.x = 100.0;
        if (this.model.getRootCount() > 1) {
            Object root = this.model.getRootAt(1);
            this.model.getAttributes(root).translate(this.x, 0.0);
            this.layout(root, new HashSet<Object>());
            for (Object r : this.model.getRoots()) {
                if (!(r instanceof HistoryCell)) continue;
                this.x = 100.0;
                this.layout(r, new HashSet<Object>());
            }
            this.model.cellsChanged(this.getCells());
        }
    }

    private void layout(Object root, Set<Object> visited) {
        int i = 0;
        for (Object edge : DefaultGraphModel.getOutgoingEdges((GraphModel)this.model, (Object)root)) {
            Object cell = this.model.getParent(this.model.getTarget(edge));
            if (!visited.contains(cell)) {
                if (i > 0 && !(edge instanceof UnfoldedBranchesEdge)) {
                    this.x += 150.0;
                }
                this.model.getAttributes(cell).translate(this.x, 0.0);
                visited.add(cell);
                this.layout(cell, visited);
            }
            if (edge instanceof UnfoldedBranchesEdge) continue;
            ++i;
        }
    }

    public void visit(UmlTree tree) {
        this.visitChilds((UmlObject)tree);
    }

    public void visit(StateTransition transition) {
        this.transition = transition;
        this.event = null;
        this.sourceState = null;
        this.targetState = null;
        this.sourceCell = null;
        this.targetCell = null;
        this.parentState = transition.getParentState();
        this.transitionFlow = null;
        this.entryFlow = null;
        this.exitFlow = null;
        this.visitChilds((UmlObject)transition);
        if (this.exitFlow != null && this.sourceCell instanceof StateCell) {
            ((StateCell)this.sourceCell).setExitFlow(this.exitFlow);
        }
        if (this.entryFlow != null && this.targetCell instanceof StateCell) {
            ((StateCell)this.targetCell).setEntryFlow(this.entryFlow);
        }
        this.createTransition();
    }

    public void visit(Event event) {
        this.event = event;
    }

    public void visit(SourceState state) {
        this.sourceState = state;
        switch (state.getStateType()) {
            case INITIAL: {
                if (this.parentState != null && !this.parentState.getOriginalName().equals(this.root.getOriginalName())) break;
                this.sourceCell = CellFactory.newCell((State)state, this.x, this.y, this.module);
                this.cells.put("initial", this.sourceCell);
                break;
            }
            case ENTRY: {
                if (this.parentState == null || !this.parentState.getOriginalName().equals(this.root.getOriginalName())) break;
                this.sourceCell = CellFactory.newCell((State)state, this.x, this.y, this.module);
                this.cells.put(state.getOriginalName(), this.sourceCell);
                break;
            }
            case HISTORY: {
                if (this.parentState == null || !this.parentState.getOriginalName().equals(this.root.getOriginalName())) break;
                this.sourceCell = CellFactory.newCell((State)state, this.x, this.y + 100.0, this.module);
                this.cells.put(state.getOriginalName(), this.sourceCell);
                break;
            }
            default: {
                if (this.parentState != null && !this.parentState.getOriginalName().equals(this.root.getOriginalName())) break;
                this.sourceCell = this.getSourceCell();
                if (this.sourceCell != null) break;
                this.sourceCell = CellFactory.newCell(this.sourceState, this.x, this.y, this.module);
                this.cells.put(this.sourceState.getOriginalName(), this.sourceCell);
            }
        }
    }

    private DefaultGraphCell getSourceCell() {
        SourceStateParent sourceStateParent;
        DefaultGraphCell cell = this.cells.getState(this.sourceState.getOriginalName());
        if (cell == null && (sourceStateParent = ((StateTransition)this.sourceState.getParent()).getSourceStateParent()) != null) {
            cell = this.cells.getState(sourceStateParent.getOriginalName());
        }
        return cell;
    }

    public void visit(TargetState state) {
        if (state == this.root) {
            this.visitChilds((UmlObject)state);
        } else {
            this.targetState = state;
            boolean addCell = this.parentState == null || this.parentState.getOriginalName().equals(this.root.getOriginalName());
            switch (state.getStateType()) {
                case CHOICE: 
                case COMPOSITE: 
                case EXIT: 
                case FINAL: 
                case FORK: 
                case ORTHOGONAL: 
                case STATE: 
                case SUBMACHINE: 
                case TERMINATE: {
                    this.targetCell = CellFactory.newCell((State)state, this.module);
                    break;
                }
                case JOIN: {
                    this.targetCell = this.cells.getState(state.getOriginalName());
                    boolean bl = addCell = this.targetCell == null;
                    if (!addCell) break;
                    this.targetCell = CellFactory.newCell((State)state, this.module);
                    break;
                }
                case ENTRY: 
                case HISTORY: {
                    addCell = false;
                    break;
                }
                case INITIAL: {
                    throw new IllegalStateException();
                }
            }
            if (addCell) {
                this.targetCell.getAttributes().translate(this.getX(), this.getY());
                this.cells.put(this.targetState.getOriginalName(), this.targetCell);
            }
        }
    }

    public void visit(TargetStateParent state) {
        if (state == this.root) {
            this.visitChilds((UmlObject)state);
        } else {
            this.targetState = state;
            switch (state.getStateType()) {
                case COMPOSITE: 
                case ORTHOGONAL: 
                case SUBMACHINE: {
                    this.targetCell = CellFactory.newCell((State)state, this.module);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.targetCell.getAttributes().translate(this.getX(), this.getY());
            this.cells.put(this.targetState.getOriginalName(), this.targetCell);
        }
    }

    public void visit(TransitionAction action) {
        this.transitionFlow = (GenericFlow)action.getChild(0);
    }

    public void visit(EntryAction action) {
        this.entryFlow = (GenericFlow)action.getChild(0);
    }

    public void visit(ExitAction action) {
        this.exitFlow = (GenericFlow)action.getChild(0);
    }

    public void visit(DoAction action) {
        State state = (State)action.getChild(0);
        GenericFlow flow = (GenericFlow)action.getChild(1);
        String key = state.getOriginalName();
        if (!this.doFlows.containsKey(key)) {
            this.doFlows.put(key, new ArrayDeque());
        }
        this.doFlows.get(key).add(flow);
    }

    private void insertDoFlows() {
        for (DefaultGraphCell cell : this.cells.values()) {
            String key;
            Deque<GenericFlow> flows;
            Object userObject;
            if (!(cell instanceof StateCell) || !((userObject = cell.getUserObject()) instanceof State) || (flows = this.doFlows.get(key = ((State)userObject).getOriginalName())) == null) continue;
            GenericFlow flow = flows.poll();
            if (flow == null) {
                throw new IllegalStateException("Misssig doActivity.");
            }
            ((StateCell)cell).setDoFlow(flow);
        }
    }

    public void visit(Branches branches) {
        State state = branches.getState();
        String key = state.getOriginalName();
        if (!this.choices.containsKey(key)) {
            this.choices.put(key, new ArrayDeque());
        }
        this.choices.get(key).add(branches);
    }

    public void visit(DefaultAction action) {
        this.signalCell = new SignalCell(action, this.module);
        this.cells.put(action.getOriginalName(), this.signalCell);
    }

    public void visit(DeleteStateObject deleteStateObject) {
        this.signalCell = new SignalCell(deleteStateObject, this.module);
        this.cells.put(deleteStateObject.getOriginalName(), this.signalCell);
    }

    private void createTransition() {
        if (this.sourceCell != null && this.targetCell != null) {
            Branches branches;
            String key = this.sourceState.getOriginalName();
            Branches branches2 = branches = this.choices.containsKey(key) ? this.choices.get(key).poll() : null;
            if (branches != null) {
                this.createNotFollowedBranches(branches);
            }
            TransitionEdge edge = new TransitionEdge(this.transition, this.transitionFlow, this.event, branches, this.module);
            Object sourcePort = this.sourceCell instanceof AbstractStateCell ? ((AbstractStateCell)this.sourceCell).getExitPort() : this.sourceCell.getChildAt(0);
            Object targetPort = this.targetCell instanceof AbstractStateCell ? ((AbstractStateCell)this.targetCell).getEntryPort() : this.targetCell.getChildAt(0);
            edge.setSource(sourcePort);
            edge.setTarget(targetPort);
            this.cells.put(this.transition.getOriginalName(), (DefaultGraphCell)edge);
        }
    }

    private void createNotFollowedBranches(Branches branches) {
        Rectangle2D bounds = UmlGraphConstants.getBounds((Map)this.sourceCell.getAttributes());
        bounds = new Rectangle2D.Double(bounds.getMaxX() + 200.0, bounds.getCenterY(), 4.0, 4.0);
        DefaultGraphCell dummy = new DefaultGraphCell();
        dummy.addPort();
        this.cells.put("decision_" + this.cells.size(), dummy);
        UmlGraphConstants.setBounds((Map)dummy.getAttributes(), (Rectangle2D)bounds);
        UmlGraphConstants.setSizeable((Map)dummy.getAttributes(), (boolean)false);
        UmlGraphConstants.setOpaque((Map)dummy.getAttributes(), (boolean)false);
        UnfoldedBranchesEdge edge = new UnfoldedBranchesEdge(branches, this.module);
        edge.setSource(((DecisionCell)this.sourceCell).getUnfoldedBranchesPort());
        edge.setTarget(dummy.getChildAt(0));
        this.cells.put("notFollowedEdge" + this.cells.size(), (DefaultGraphCell)edge);
    }

    private double getX() {
        Rectangle2D sourceBounds = UmlGraphConstants.getBounds((Map)this.sourceCell.getAttributes());
        Rectangle2D targetBounds = UmlGraphConstants.getBounds((Map)this.targetCell.getAttributes());
        return sourceBounds.getCenterX() - 0.5 * targetBounds.getWidth();
    }

    private double getY() {
        this.y = UmlGraphConstants.getBounds((Map)this.sourceCell.getAttributes()).getMaxY() + 50.0;
        return this.y;
    }

    private void initializeGraph() {
        this.model = new DefaultGraphModel();
        this.graph = new UmlGraph(this.module, (GraphModel)this.model, new GraphLayoutCache((GraphModel)this.model, (CellViewFactory)new UmlCellViewFactory()));
    }

    private void createInfoCell() {
        InfoCell cell = new InfoCell(this.testcase, STATE_DIAGRAM_TITLE);
        cell.addPort();
        this.cells.put("info", cell);
        this.y = UmlGraphConstants.getBounds((Map)cell.getAttributes()).getMaxY() + 30.0;
    }

    private static class CellFactory {
        public static DefaultGraphCell newCell(State state, E2EBuilderModule module) {
            UmlCell cell;
            switch (state.getStateType()) {
                default: {
                    cell = new StateCell(state, module);
                    break;
                }
                case CHOICE: {
                    cell = new DecisionCell(state);
                    break;
                }
                case COMPOSITE: 
                case SUBMACHINE: {
                    cell = new CompositeCell(state, module);
                    break;
                }
                case ENTRY: {
                    cell = new EntryCell(state);
                    break;
                }
                case EXIT: {
                    cell = new ExitCell();
                    break;
                }
                case FINAL: {
                    cell = new FinalNodeCell();
                    cell.addPort();
                    break;
                }
                case FORK: 
                case JOIN: {
                    cell = new ForkOrJoinCell(state);
                    break;
                }
                case HISTORY: {
                    cell = new HistoryCell(state);
                    break;
                }
                case INITIAL: {
                    cell = new InitialNodeCell();
                    cell.addPort();
                    break;
                }
                case ORTHOGONAL: {
                    cell = new StateCell(state.getOriginalName() + ": not implemented", module);
                    break;
                }
                case TERMINATE: {
                    cell = new TerminateCell();
                }
            }
            return cell;
        }

        public static DefaultGraphCell newCell(State state, double x, double y, E2EBuilderModule module) {
            DefaultGraphCell cell = CellFactory.newCell(state, module);
            cell.getAttributes().translate(x, y);
            return cell;
        }

        private CellFactory() {
        }
    }

    private static class CellMap
    implements Map<String, DefaultGraphCell> {
        private Map<String, LinkedList<DefaultGraphCell>> map = new LinkedHashMap<String, LinkedList<DefaultGraphCell>>();

        private CellMap() {
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            boolean result = false;
            for (LinkedList<DefaultGraphCell> cells : this.map.values()) {
                if (!cells.contains(value)) continue;
                result = true;
                break;
            }
            return result;
        }

        @Override
        public DefaultGraphCell get(Object key) {
            if (key instanceof String) {
                LinkedList<DefaultGraphCell> cells = this.map.get(key);
                return cells == null ? null : cells.getLast();
            }
            throw new ClassCastException();
        }

        public DefaultGraphCell getState(String key) {
            DefaultGraphCell state = null;
            LinkedList<DefaultGraphCell> cells = this.map.get(key);
            if (cells != null) {
                ListIterator<DefaultGraphCell> iterator = cells.listIterator(cells.size());
                while (state == null && iterator.hasPrevious()) {
                    DefaultGraphCell cell = iterator.previous();
                    if (!(cell instanceof StateCell) && !(cell instanceof ForkOrJoinCell) && !(cell instanceof DecisionCell)) continue;
                    state = cell;
                }
            }
            return state;
        }

        @Override
        public DefaultGraphCell remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.map.keySet();
        }

        @Override
        public Collection<DefaultGraphCell> values() {
            ArrayList<DefaultGraphCell> values = new ArrayList<DefaultGraphCell>();
            for (LinkedList<DefaultGraphCell> cells : this.map.values()) {
                values.addAll(cells);
            }
            return values;
        }

        @Override
        public Set<Map.Entry<String, DefaultGraphCell>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends DefaultGraphCell> t) {
            for (Map.Entry<? extends String, ? extends DefaultGraphCell> entry : t.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public DefaultGraphCell put(String key, DefaultGraphCell value) {
            DefaultGraphCell previousValue = null;
            LinkedList<Object> cells = this.map.get(key);
            if (cells == null) {
                cells = new LinkedList();
                this.map.put(key, cells);
            } else {
                previousValue = cells.getLast();
            }
            cells.add(value);
            return previousValue;
        }
    }
}

