/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.tasks.test;

import ch.e2e.ant.gui.junit.E2ETestListener;
import ch.e2e.ant.tasks.test.TestTask;
import ch.e2e.test.junit.TestUnit;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.BuildException;

public class JUnitTest
implements TestTask {
    @Override
    public void doTest(Class testClass) {
        try {
            Method suiteMethod = null;
            try {
                suiteMethod = testClass.getMethod("suite", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (suiteMethod != null) {
                Test test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
            } else {
                TestSuite test = new TestSuite(testClass);
            }
            TestUnit testUnit = new TestUnit();
            this.doTest(testUnit);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void doTest(Test test) {
        long startTime = System.currentTimeMillis();
        TestResult testResult = new TestResult();
        E2ETestListener testListener = E2ETestListener.getInstance();
        testListener.testStarting(test, testResult);
        test.run(testResult);
        if (testResult.shouldStop()) {
            testListener.showStatus("Stopped", 0);
        } else {
            long endTime = System.currentTimeMillis();
            long runTime = endTime - startTime;
            testListener.showStatus("Finished: " + NumberFormat.getInstance().format((double)runTime / 1000.0) + " seconds", 1);
        }
        testListener.testFinished(test, testResult);
    }

    public void doTest(TestUnit test) {
        long startTime = System.currentTimeMillis();
        TestResult testResult = new TestResult();
        E2ETestListener testListener = E2ETestListener.getInstance();
        testListener.testStarting(test, testResult);
        test.run(testResult);
        if (testResult.shouldStop()) {
            testListener.showStatus("Stopped", 0);
        } else {
            long endTime = System.currentTimeMillis();
            long runTime = endTime - startTime;
            testListener.showStatus("Finished: " + NumberFormat.getInstance().format((double)runTime / 1000.0) + " seconds", 1);
        }
        testListener.testFinished((Test)test, testResult);
    }
}

