/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.junit;

import ch.e2e.ant.gui.junit.JUnitTestTreeModel;
import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.test.junit.TestUnit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JUnitTestSuitePanel
extends JPanel {
    private Tree tree;

    public JUnitTestSuitePanel() {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(300, 100));
        this.tree = new Tree((AbstractTreeModel)new JUnitTestTreeModel(new TestUnit()));
        this.tree.setRowHeight(20);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.tree);
        this.tree.putClientProperty((Object)"JTree.lineStyle", (Object)"Angled");
        JScrollPane fScrollTree = new JScrollPane((Component)this.tree);
        this.add((Component)fScrollTree, "Center");
    }

    public Object getSelectedValue() {
        Object value = null;
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null && paths.length == 1) {
            value = paths[0].getLastPathComponent();
        }
        return value;
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setTestUnit(TestUnit testUnit) {
        ((JUnitTestTreeModel)((Object)this.tree.getModel())).setRoot(testUnit);
        SwingUtilities.updateComponentTreeUI((Component)this.tree);
    }

    public void setCellRenderer(TreeCellRenderer cellRenderer) {
        this.tree.setCellRenderer(cellRenderer);
    }

    public void clear() {
        TreeModel model = this.tree.getModel();
        if (model != null && model instanceof JUnitTestTreeModel) {
            ((JUnitTestTreeModel)((Object)model)).getRoot().resetResults();
        }
    }
}

